/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.ZERTSSLSocketImpl;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class ZERTOutputStream
extends OutputStream {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTOutputStream";
    private OutputStream oStream;
    private ZERTSSLSocketImpl socket;

    public ZERTOutputStream(OutputStream oStream, ZERTSSLSocketImpl socket) {
        String methodName = "ZERTOutputStream";
        Debug.traceEntry(debug, className, methodName, oStream, socket);
        this.oStream = oStream;
        this.socket = socket;
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void write(int b) throws IOException {
        String methodName = "write";
        Debug.traceEntry(debug, className, methodName, b);
        try {
            this.oStream.write(b);
        }
        catch (InterruptedIOException e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (IOException e) {
            Debug.traceException(debug, className, methodName, e);
            this.socket.notifyzERTFailure();
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        this.socket.notifyzERTHandshakePossible();
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void write(byte[] b) throws IOException {
        String methodName = "write";
        Debug.traceEntry(debug, className, methodName, (Object)b);
        try {
            this.oStream.write(b);
        }
        catch (InterruptedIOException e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (IOException e) {
            Debug.traceException(debug, className, methodName, e);
            this.socket.notifyzERTFailure();
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        this.socket.notifyzERTHandshakePossible();
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        String methodName = "write";
        Debug.traceEntry(debug, className, methodName, "b: " + b + ", off: " + off + ", len: " + len);
        try {
            this.oStream.write(b, off, len);
        }
        catch (InterruptedIOException e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (IOException e) {
            Debug.traceException(debug, className, methodName, e);
            this.socket.notifyzERTFailure();
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        this.socket.notifyzERTHandshakePossible();
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void flush() throws IOException {
        String methodName = "flush";
        Debug.traceEntry(debug, className, methodName);
        try {
            this.oStream.flush();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void close() throws IOException {
        String methodName = "close";
        Debug.traceEntry(debug, className, methodName);
        try {
            this.socket.notifyzERTRenegotiation();
            this.oStream.close();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        finally {
            this.socket.notifyzERTTermination();
        }
        Debug.traceExit(debug, className, methodName);
    }
}

