/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;

public final class ZERTJSSE
extends Provider {
    static final long serialVersionUID = -7704267969561265640L;
    private static String info = "ZERTJSSE Provider";
    private static Debug debug = Debug.getInstance("zertjsse");
    private static String className = "com.ibm.zertjsse.ZERTJSSE";
    static boolean register = true;
    static boolean disableSSLv3;
    static boolean convertSSLv3;
    static boolean useFIPSProvider;

    private static void initProperties() {
        String methodName = "initProperties";
        Debug.traceEntry(debug, className, methodName);
        try {
            Class.forName("com.ibm.zos.net.SiocSSecattr");
        }
        catch (Error | Exception e) {
            register = false;
            Debug.traceText(debug, className, methodName, "Unable to load the zERT Java API, setting register to false");
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            return;
        }
        Debug.traceText(debug, className, methodName, "Able to load the zERT Java API, setting register to true");
        disableSSLv3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ZERTJSSE.getBooleanProperty("com.ibm.jsse2.disableSSLv3", true);
            }
        });
        Debug.traceText(debug, className, methodName, "disableSSLv3 set to " + disableSSLv3);
        convertSSLv3 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ZERTJSSE.getBooleanProperty("com.ibm.jsse2.convertSSLv3", false);
            }
        });
        Debug.traceText(debug, className, methodName, "convertSSLv3 set to " + convertSSLv3);
        useFIPSProvider = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ZERTJSSE.getBooleanProperty("com.ibm.jsse2.usefipsprovider", false);
            }
        });
        Debug.traceText(debug, className, methodName, "useFIPSProvider set to " + useFIPSProvider);
        Debug.traceExit(debug, className, methodName);
    }

    public ZERTJSSE() {
        super("ZERTJSSE", 1.8, info);
        String methodName = "ZERTJSSE";
        Debug.traceEntry(debug, className, "ZERTJSSE");
        if (register) {
            Debug.traceText(debug, className, "ZERTJSSE", "register is true, registering for protocols");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ZERTJSSE.this.put("SSLContext.SSL", "com.ibm.zertjsse.ZERTSSLContextImplSSL");
                    if (convertSSLv3 || !disableSSLv3) {
                        Debug.traceText(debug, className, "ZERTJSSE", "Registering for SSLv3");
                        ZERTJSSE.this.put("SSLContext.SSLv3", "com.ibm.zertjsse.ZERTSSLContextImplSSLv3");
                    } else {
                        Debug.traceText(debug, className, "ZERTJSSE", "Not registering for SSLv3");
                    }
                    ZERTJSSE.this.put("SSLContext.TLS", "com.ibm.zertjsse.ZERTSSLContextImplTLS");
                    ZERTJSSE.this.put("SSLContext.TLSv1", "com.ibm.zertjsse.ZERTSSLContextImplTLSv10");
                    ZERTJSSE.this.put("SSLContext.TLSv1.1", "com.ibm.zertjsse.ZERTSSLContextImplTLSv11");
                    ZERTJSSE.this.put("SSLContext.TLSv1.2", "com.ibm.zertjsse.ZERTSSLContextImplTLSv12");
                    ZERTJSSE.this.put("SSLContext.SSL_TLS", "com.ibm.zertjsse.ZERTSSLContextImplSSL_TLS");
                    ZERTJSSE.this.put("SSLContext.SSL_TLSv2", "com.ibm.zertjsse.ZERTSSLContextImplSSL_TLSv2");
                    ZERTJSSE.this.put("SSLContext.Default", "com.ibm.zertjsse.ZERTDefaultSSLContextImpl");
                    return null;
                }
            });
        } else {
            Debug.traceText(debug, className, "ZERTJSSE", "register is false, not registering for protocols");
        }
        Debug.traceExit(debug, className, "ZERTJSSE");
    }

    protected static boolean getUseFIPSProvider() {
        String methodName = "getUseFIPSProvider";
        Debug.traceEntry(debug, className, methodName);
        Debug.traceExit(debug, className, methodName, useFIPSProvider);
        return useFIPSProvider;
    }

    private static boolean getBooleanProperty(String propName, boolean defaultValue) {
        String methodName = "getBooleanProperty";
        Debug.traceEntry(debug, className, methodName, propName, defaultValue);
        final String theProp = propName;
        boolean returnValue = false;
        String b = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(theProp);
            }
        });
        if (b == null) {
            returnValue = defaultValue;
            Debug.traceExit(debug, className, methodName, returnValue);
            return returnValue;
        }
        if (b.equalsIgnoreCase("false")) {
            returnValue = false;
            Debug.traceExit(debug, className, methodName, returnValue);
            return returnValue;
        }
        if (b.equalsIgnoreCase("true")) {
            returnValue = true;
            Debug.traceExit(debug, className, methodName, returnValue);
            return returnValue;
        }
        RuntimeException e = new RuntimeException("Value of " + propName + " must either be 'true' or 'false'");
        Debug.traceException(debug, className, methodName, e);
        Debug.traceExit(debug, className, methodName);
        throw e;
    }

    static {
        ZERTJSSE.initProperties();
    }
}

