/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath
implements Serializable {
    public static final ClassPath SYSTEM_CLASS_PATH = new ClassPath();
    private PathEntry[] paths;
    private String class_path;

    public ClassPath(final String class_path) {
        this.class_path = class_path;
        ArrayList newvec = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
                StringTokenizer tok = new StringTokenizer(class_path, System.getProperty("path.separator"));
                while (tok.hasMoreTokens()) {
                    String path = tok.nextToken();
                    if (path.equals("")) continue;
                    File file = new File(path);
                    try {
                        if (!file.exists()) continue;
                        if (file.isDirectory()) {
                            vec.add(new Dir(path));
                            continue;
                        }
                        vec.add(new Zip(new ZipFile(file)));
                    }
                    catch (IOException e) {}
                }
                return vec;
            }
        });
        this.paths = new PathEntry[newvec.size()];
        newvec.toArray(this.paths);
    }

    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    public String toString() {
        return this.class_path;
    }

    public int hashCode() {
        return this.class_path.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ClassPath) {
            return this.class_path.equals(((ClassPath)o).class_path);
        }
        return false;
    }

    private static final void getPathComponents(String path, final ArrayList list) {
        if (path != null) {
            final StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    while (tok.hasMoreTokens()) {
                        String name = tok.nextToken();
                        File file = new File(name);
                        if (!file.exists()) continue;
                        list.add(name);
                    }
                    return null;
                }
            });
        }
    }

    public static final String getClassPath() {
        String class_path = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.class.path");
            }
        });
        String boot_path = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.boot.class.path");
            }
        });
        String ext_path = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.ext.dirs");
            }
        });
        ArrayList<String> list = new ArrayList<String>();
        ClassPath.getPathComponents(class_path, list);
        ClassPath.getPathComponents(boot_path, list);
        ArrayList dirs = new ArrayList();
        ClassPath.getPathComponents(ext_path, dirs);
        Iterator e = dirs.iterator();
        while (e.hasNext()) {
            final File ext_dir = new File((String)e.next());
            String[] extensions = (String[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ext_dir.list(new FilenameFilter(this){
                        private final /* synthetic */ 6 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public boolean accept(File dir, String name) {
                            return (name = name.toLowerCase()).endsWith(".zip") || name.endsWith(".jar");
                        }
                    });
                }
            });
            if (extensions == null) continue;
            for (int i = 0; i < extensions.length; ++i) {
                list.add(ext_path + File.separatorChar + extensions[i]);
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator e2 = list.iterator();
        while (e2.hasNext()) {
            buf.append((String)e2.next());
            if (!e2.hasNext()) continue;
            buf.append(File.pathSeparatorChar);
        }
        return buf.toString().intern();
    }

    public InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, ".class");
    }

    public InputStream getInputStream(String name, String suffix) throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(name + suffix);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public ClassFile getClassFile(String name, String suffix) throws IOException {
        for (int i = 0; i < this.paths.length; ++i) {
            ClassFile cf = this.paths[i].getClassFile(name, suffix);
            if (cf == null) continue;
            return cf;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    public ClassFile getClassFile(String name) throws IOException {
        return this.getClassFile(name, ".class");
    }

    public byte[] getBytes(String name, String suffix) throws IOException {
        InputStream is = this.getInputStream(name, suffix);
        if (is == null) {
            throw new IOException("Couldn't find: " + name + suffix);
        }
        DataInputStream dis = new DataInputStream(is);
        byte[] bytes = new byte[is.available()];
        dis.readFully(bytes);
        dis.close();
        is.close();
        return bytes;
    }

    public byte[] getBytes(String name) throws IOException {
        return this.getBytes(name, ".class");
    }

    public String getPath(String name) throws IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public String getPath(String name, String suffix) throws IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
        }

        ClassFile getClassFile(String name, String suffix) throws IOException {
            ZipEntry entry = this.zip.getEntry(name.replace('.', '/') + suffix);
            return entry != null ? new ClassFile(this, entry){
                private final /* synthetic */ ZipEntry val$entry;
                private final /* synthetic */ Zip this$0;
                {
                    this.this$0 = this$0;
                    this.val$entry = val$entry;
                }

                public InputStream getInputStream() throws IOException {
                    return Zip.access$200(this.this$0).getInputStream(this.val$entry);
                }

                public String getPath() {
                    return this.val$entry.toString();
                }

                public long getTime() {
                    return this.val$entry.getTime();
                }

                public long getSize() {
                    return this.val$entry.getSize();
                }

                public String getBase() {
                    return Zip.access$200(this.this$0).getName();
                }
            } : null;
        }

        static /* synthetic */ ZipFile access$200(Zip x0) {
            return x0.zip;
        }
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(String d) {
            this.dir = d;
        }

        ClassFile getClassFile(String name, String suffix) throws IOException {
            File file = new File(this.dir + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(this, file){
                private final /* synthetic */ File val$file;
                private final /* synthetic */ Dir this$0;
                {
                    this.this$0 = this$0;
                    this.val$file = val$file;
                }

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(this.val$file);
                }

                public String getPath() {
                    try {
                        return this.val$file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                public long getTime() {
                    return this.val$file.lastModified();
                }

                public long getSize() {
                    return this.val$file.length();
                }

                public String getBase() {
                    return Dir.access$100(this.this$0);
                }
            } : null;
        }

        public String toString() {
            return this.dir;
        }

        static /* synthetic */ String access$100(Dir x0) {
            return x0.dir;
        }
    }

    public static interface ClassFile {
        public InputStream getInputStream() throws IOException;

        public String getPath();

        public String getBase();

        public long getTime();

        public long getSize();
    }

    private static abstract class PathEntry
    implements Serializable {
        private PathEntry() {
        }

        abstract ClassFile getClassFile(String var1, String var2) throws IOException;
    }
}

