/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.res;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class BaseMsg {
    private String m_code;
    private String m_message = null;
    private Object[] m_params = null;

    public BaseMsg(String string, Object[] objectArray) {
        this.m_code = string;
        this.m_params = objectArray;
    }

    public BaseMsg(String string) {
        this.m_message = string;
    }

    public BaseMsg(String string, boolean bl) {
        if (bl) {
            this.m_code = string;
        } else {
            this.m_message = string;
        }
    }

    protected abstract ResourceBundle getBundle();

    public String toString() {
        String string = this.m_params == null ? (null != this.m_code ? new String(this.getErrorMessage()) : this.m_message) : MessageFormat.format(this.getErrorMessage(), this.m_params);
        return this.formatLine() + string;
    }

    public String toString(Object object) {
        Object[] objectArray = new Object[]{object.toString()};
        String string = MessageFormat.format(this.getErrorMessage(), objectArray);
        return this.formatLine() + string;
    }

    public String toString(Object object, Object object2) {
        Object[] objectArray = new Object[]{object.toString(), object2.toString()};
        String string = MessageFormat.format(this.getErrorMessage(), objectArray);
        return this.formatLine() + string;
    }

    public String getFormattedMessage() {
        String string = this.m_params == null ? (null != this.m_code ? new String(this.getErrorMessage()) : this.m_message) : MessageFormat.format(this.getErrorMessage(), this.m_params);
        return string;
    }

    protected abstract String formatLine();

    public String getErrorCode() {
        return this.m_code;
    }

    public Object[] getParams() {
        return this.m_params;
    }

    private String getErrorMessage() {
        return this.getBundle().getString(this.m_code);
    }
}

