/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IntegerHashtable {
    private static final int HASHTABLE_SIZE = 128;
    private static final int INITIAL_BUCKET_COUNT = 2;
    private static final int HEADER_SIZE = 1;
    private int[][] fTable = new int[128][];
    private int fKeyCount;

    public int size() {
        return this.fKeyCount;
    }

    public int get(int n) {
        if (this.fKeyCount == 0) {
            return -1;
        }
        int n2 = n % 128;
        int[] nArray = this.fTable[n2];
        if (nArray != null) {
            int n3 = 1 + (nArray[0] << 1);
            for (int i = 1; i < n3; i += 2) {
                if (n != nArray[i]) continue;
                return nArray[i + 1];
            }
        }
        return -1;
    }

    public int put(int n, int n2) {
        int n3 = n % 128;
        int[] nArray = this.fTable[n3];
        if (nArray != null) {
            int n4 = 1 + (nArray[0] << 1);
            for (int i = 1; i < n4; i += 2) {
                if (n != nArray[i]) continue;
                int n5 = nArray[i + 1];
                nArray[i + 1] = n2;
                return n5;
            }
            nArray[0] = nArray[0] + 1;
            if (n4 >= nArray.length) {
                int n6 = (nArray.length << 1) - 1;
                int[] nArray2 = new int[n6];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
                this.fTable[n3] = nArray;
            }
            nArray[n4] = n;
            nArray[n4 + 1] = n2;
        } else {
            nArray = new int[5];
            nArray[0] = 1;
            nArray[1] = n;
            nArray[2] = n2;
            this.fTable[n3] = nArray;
        }
        ++this.fKeyCount;
        return -1;
    }

    public int getKey(int n) {
        int n2 = 0;
        for (int i = 0; this.fKeyCount > n2 && i < 128; ++i) {
            int[] nArray = this.fTable[i];
            if (nArray == null) continue;
            int n3 = 1 + (nArray[0] << 1);
            for (int j = 1; j < n3; j += 2) {
                if (nArray[j + 1] == n) {
                    return nArray[j];
                }
                ++n2;
            }
        }
        return -1;
    }

    public void getKeys(int[] nArray) {
        int n = 0;
        for (int i = 0; this.fKeyCount > n && i < 128; ++i) {
            int[] nArray2 = this.fTable[i];
            if (nArray2 == null) continue;
            int n2 = 1 + (nArray2[0] << 1);
            for (int j = 1; j < n2; j += 2) {
                nArray[n++] = nArray2[j];
            }
        }
    }

    public void clear(boolean bl) {
        for (int i = 0; this.fKeyCount > 0 && i < 128; ++i) {
            int[] nArray = this.fTable[i];
            if (nArray == null) continue;
            this.fKeyCount -= nArray[0];
            if (bl) {
                nArray[0] = 0;
                continue;
            }
            this.fTable[i] = null;
        }
    }

    static void writeInt32(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 24);
        outputStream.write(n >> 16);
        outputStream.write(n >> 8);
        outputStream.write(n);
    }

    public boolean save(OutputStream outputStream) throws IOException {
        int n = this.fKeyCount;
        IntegerHashtable.writeInt32(outputStream, n);
        n = 0;
        for (int i = 0; this.fKeyCount > n && i < 128; ++i) {
            int[] nArray = this.fTable[i];
            if (nArray == null) continue;
            int n2 = 1 + (nArray[0] << 1);
            for (int j = 1; j < n2; j += 2) {
                int n3 = nArray[j];
                int n4 = nArray[j + 1];
                IntegerHashtable.writeInt32(outputStream, n3);
                IntegerHashtable.writeInt32(outputStream, n4);
                ++n;
            }
        }
        return true;
    }

    static int readInt32(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        n = n << 8 | inputStream.read() & 0xFF;
        return n;
    }

    public boolean restore(InputStream inputStream) throws IOException {
        int n = IntegerHashtable.readInt32(inputStream);
        if (n > 0 && this.fKeyCount > 0) {
            this.clear(true);
        }
        for (int i = 0; i < n; ++i) {
            int n2 = IntegerHashtable.readInt32(inputStream);
            int n3 = IntegerHashtable.readInt32(inputStream);
            this.put(n2, n3);
        }
        return true;
    }
}

