/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.attacher;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachine;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachineDescriptor;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachPermission;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import openj9.internal.tools.attach.target.Advertisement;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.TargetDirectory;

public class OpenJ9AttachProvider
extends AttachProvider {
    @Override
    public OpenJ9VirtualMachine attachVirtualMachine(String id) throws AttachNotSupportedException, IOException {
        OpenJ9AttachProvider.checkAttachSecurity();
        try {
            OpenJ9VirtualMachine vm = new OpenJ9VirtualMachine(this, id);
            IPC.logMessage((String)("Attach target id: " + id));
            vm.attachTarget();
            return vm;
        }
        catch (NullPointerException e) {
            AttachNotSupportedException exc = new AttachNotSupportedException(Msg.getString((String)"K0554"));
            exc.initCause(e);
            throw exc;
        }
    }

    @Override
    public OpenJ9VirtualMachine attachVirtualMachine(VirtualMachineDescriptor descriptor) throws AttachNotSupportedException, IOException {
        OpenJ9AttachProvider.checkAttachSecurity();
        if (!(descriptor.provider() instanceof OpenJ9AttachProvider)) {
            throw new AttachNotSupportedException(Msg.getString((String)"K0543"));
        }
        String id = descriptor.id();
        OpenJ9VirtualMachine vm = new OpenJ9VirtualMachine(this, id);
        IPC.logMessage((String)("Attach target descriptor.id(): " + id));
        vm.attachTarget();
        return vm;
    }

    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        List ret = null;
        PrivilegedExceptionAction<List> action = () -> this.listVirtualMachinesImp();
        try {
            ret = AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VirtualMachineDescriptor> listVirtualMachinesImp() {
        AttachHandler.waitForAttachApiInitialization();
        File commonDir = CommonDirectory.getCommonDirFileObject();
        ArrayList<VirtualMachineDescriptor> descriptors = new ArrayList<VirtualMachineDescriptor>();
        if (null == commonDir) {
            IPC.logMessage((String)"listVirtualMachines() error getting common directory");
            return null;
        }
        if (!commonDir.exists()) {
            IPC.logMessage((String)("listVirtualMachines() common directory is absent, expected " + commonDir.getAbsolutePath()));
            return descriptors;
        }
        if (!commonDir.isDirectory()) {
            IPC.logMessage((String)("listVirtualMachines() common directory is mis-configured for " + commonDir.getAbsolutePath()));
            return null;
        }
        try {
            CommonDirectory.obtainControllerLock((String)"OpenJ9AttachProvider.listVirtualMachinesImp");
        }
        catch (IOException e) {
            IPC.logMessage((String)"listVirtualMachines() IOError on controller lock : ", (String)e.toString());
            return descriptors;
        }
        try {
            File[] vmDirs = commonDir.listFiles();
            if (vmDirs == null) {
                ArrayList<VirtualMachineDescriptor> arrayList = descriptors;
                return arrayList;
            }
            long myUid = IPC.getUid();
            for (File f : vmDirs) {
                if (!f.isDirectory() || !CommonDirectory.isFileOwnedByUid((File)f, (long)myUid)) continue;
                boolean staleDirectory = true;
                File advertisement = new File(f, Advertisement.getFilename());
                long uid = 0L;
                if (advertisement.exists()) {
                    OpenJ9VirtualMachineDescriptor descriptor = OpenJ9VirtualMachineDescriptor.fromAdvertisement(this, advertisement);
                    if (null != descriptor) {
                        long pid = descriptor.getProcessId();
                        uid = descriptor.getUid();
                        if (0L == pid || IPC.processExists((long)pid)) {
                            descriptors.add(descriptor);
                            staleDirectory = false;
                        }
                    }
                    if (myUid != 0L && 0L == uid) {
                        uid = CommonDirectory.getFileOwner((String)advertisement.getAbsolutePath());
                    }
                }
                if (!staleDirectory || myUid != 0L && uid != myUid) continue;
                IPC.logMessage((String)"listVirtualMachines() removing stale directory : ", (String)f.getName());
                TargetDirectory.deleteTargetDirectory((String)f.getName());
            }
        }
        finally {
            CommonDirectory.releaseControllerLock((String)"OpenJ9AttachProvider.listVirtualMachinesImp");
        }
        return descriptors;
    }

    VirtualMachineDescriptor getDescriptor(String id) {
        List<VirtualMachineDescriptor> vmds = this.listVirtualMachines();
        if (null != vmds) {
            for (VirtualMachineDescriptor vmd : vmds) {
                if (!vmd.id().equalsIgnoreCase(id)) continue;
                return vmd;
            }
        }
        return null;
    }

    @Override
    public String name() {
        return "IBM";
    }

    @Override
    public String type() {
        return "Java SE";
    }

    private static void checkAttachSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.ATTACH_VM);
        }
    }

    static class Permissions {
        static final AttachPermission ATTACH_VM = new AttachPermission("attachVirtualMachine", null);

        Permissions() {
        }
    }
}

