/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.EventCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Util;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.TransportType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HealthCenterOptionHandler {
    private static final String KEEP_DEFAULT_TRACE = "keepDefaultTrace";
    private static final String KEEP_ALIVE = "keepAlive";
    private static final String DYNAMIC_TRACE = "dynamicTrace";
    public static final String HEALTH_CENTER_PROPERTY_PREFIX = "com.ibm.java.diagnostics.healthcenter.";
    public static final String CAPABILITY_PROPERTY_PREFIX = "com.ibm.diagnostics.healthcenter.capability.";
    private static final String DEFAULT_TRACE_OVERRIDE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.leave.default.trace";
    private static final String NODYNAMIC_TRACE_OVERRIDE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.leave.dynamic.trace";
    private static final String DATA_COLLECTION_LEVEL_PROPERTY = "com.ibm.java.diagnostics.healthcenter.data.collection.level";
    public static final String AGENT_PATH_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.path";
    public static final String CONFIG_OVERRIDE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.config";
    private final Logger logger;
    private static final String HEALTHCENTER_PROPERTIES_FILE_NAME = "healthcenter.properties";
    private static final String MAX_CIRCULAR_BUFFER_SIZE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.bufferSize";
    private static final String STACK_TRACE_DEPTH = "com.ibm.java.diagnostics.healthcenter.stack.trace.depth";
    private static final String ALLOCATION_THRESHOLD_LOW = "com.ibm.java.diagnostics.healthcenter.allocation.threshold.low";
    private static final String ALLOCATION_THRESHOLD_HIGH = "com.ibm.java.diagnostics.healthcenter.allocation.threshold.high";
    private static final String THREAD_COLLECTION_INTERVAL = "com.ibm.java.diagnostics.healthcenter.thread.collection.interval";
    private static final String THREAD_STACK_DEPTH = "com.ibm.java.diagnostics.healthcenter.thread.stack.depth";
    public static final String JRE = "jre";
    public static final String LIB = "lib";
    public static final String CONF = "conf";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String JAVA_HOME = "java.home";
    private static final String PORT_ARGUMENT = "port";
    private static final String LEVEL_ARGUMENT = "level";
    private static final String TRANSPORT_ARGUMENT = "transport";
    public static final String PATH_ARGUMENT = "path";
    private static final int MAX_PORT = 65535;
    public static final String CONFIG_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.properties.file";
    public static final String AUTHENTICATION_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.authentication.file";
    private String autheFile = null;
    public static final String AUTHORIZATION_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.authorization.file";
    private String authoFile = null;
    public static final String SSL_KEYSTORE_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStore";
    private String sslKeystore = null;
    public static final String SSL_KEYSTORE_PASSWORD_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStorePassword";
    private String sslKeystorePassword = null;
    public static final String SSL_KEYSTORE_CERTIFICATE_PASSWORD_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStoreCertificatePassword";
    private String sslKeystoreCertificatePassword = null;
    public static final String SSL_TRUSTSTORE_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStore";
    private String sslTruststore = null;
    public static final String SSL_TRUSTSTORE_PASSWORD_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStorePassword";
    private String sslTruststorePassword = null;
    public static final String SSL_TRUSTSTORE_CERTIFICATE_PASSWORD_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStoreCertificatePassword";
    private String sslTruststoreCertificatePassword = null;
    public static final String START_DELAY_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.start.delay.seconds";
    private int startDelaySeconds = 0;
    public static final String ORB_HOSTNAME_PROPERTY = "com.ibm.CORBA.LocalHost";
    public static final String ORB_PORT_PROPERTY = "com.ibm.CORBA.ListenerPort";
    public static final String RMI_HOSTNAME_PROPERTY = "java.rmi.server.hostname";
    public static final String JMX_BUILDER_PROPERTY = "javax.management.builder.initial";
    public static final String CLEAR_BUILDER_PROPERTY = "com.ibm.java.diagnostics.healthcenter.clear.jmx.initial.builder";
    private boolean tryOverrideBuilder = false;
    public static final String USE_PLATFORM_MBEANSERVER_PROPERTY = "com.ibm.java.diagnostics.healthcenter.use.platformmbeanserver";
    private boolean usePlatformMBeanServer = false;
    public static final String AGENT_PORT_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.port";
    private int startPort = 1972;
    private static final String OUTPUT_DIRECTORY_PROPERTY = "com.ibm.java.diagnostics.healthcenter.output.directory";
    private static final String HEADLESS_OUTPUT_DIRECTORY_PROPERTY = "com.ibm.java.diagnostics.healthcenter.headless.output.directory";
    private static final String HEADLESS_USER_FILE_NAME = "com.ibm.java.diagnostics.healthcenter.headless.filename";
    private static final String AGENT_TRANSPORT_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.transport";
    public static final String AGENT_IIOP_PORT_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.iiop.port";
    private static final String HEADLESS_START_DELAY = "com.ibm.java.diagnostics.healthcenter.headless.delay.start";
    private static final String HEADLESS_RUN_DURATION = "com.ibm.java.diagnostics.healthcenter.headless.run.duration";
    private static final String HEADLESS_RUN_PAUSE_DURATION = "com.ibm.java.diagnostics.healthcenter.headless.run.pause.duration";
    private static final String HEADLESS_RUN_NUMBER_OF_RUNS = "com.ibm.java.diagnostics.healthcenter.headless.run.number.of.runs";
    private static final String HEADLESS_RUN_FILES_TO_KEEP = "com.ibm.java.diagnostics.healthcenter.headless.files.to.keep";
    private static final String HEADLESS_MAX_FILE_SIZE = "com.ibm.java.diagnostics.healthcenter.headless.files.max.size";
    private int pid = 0;
    private Set<String> agentArguments = new HashSet<String>();
    private static final String[] hcUnitaryOptions = new String[]{"keepDefaultTrace", "keepAlive", "dynamicTrace"};
    private static final String[] hcPropertyKeys = new String[]{"com.ibm.java.diagnostics.healthcenter.agent.debug", "com.ibm.java.diagnostics.healthcenter.leave.default.trace", "com.ibm.java.diagnostics.healthcenter.leave.dynamic.trace", "com.ibm.java.diagnostics.healthcenter.data.collection.level", "com.ibm.java.diagnostics.healthcenter.agent.bufferSize", "com.ibm.java.diagnostics.healthcenter.stack.trace.depth", "com.ibm.java.diagnostics.healthcenter.allocation.threshold.low", "com.ibm.java.diagnostics.healthcenter.allocation.threshold.high", "com.ibm.java.diagnostics.healthcenter.agent.properties.file", "com.ibm.java.diagnostics.healthcenter.agent.authentication.file", "com.ibm.java.diagnostics.healthcenter.agent.authorization.file", "com.ibm.java.diagnostics.healthcenter.agent.start.delay.seconds", "com.ibm.java.diagnostics.healthcenter.clear.jmx.initial.builder", "com.ibm.java.diagnostics.healthcenter.use.platformmbeanserver", "com.ibm.java.diagnostics.healthcenter.agent.port", "com.ibm.java.diagnostics.healthcenter.headless.output.directory", "com.ibm.java.diagnostics.healthcenter.agent.transport", "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStore", "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStorePassword", "com.ibm.java.diagnostics.healthcenter.agent.ssl.keyStoreCertificatePassword", "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStore", "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStorePassword", "com.ibm.java.diagnostics.healthcenter.agent.ssl.trustStoreCertificatePassword", "com.ibm.java.diagnostics.healthcenter.headless.delay.start", "com.ibm.java.diagnostics.healthcenter.headless.run.duration", "com.ibm.java.diagnostics.healthcenter.headless.run.pause.duration", "com.ibm.java.diagnostics.healthcenter.headless.run.number.of.runs", "com.ibm.java.diagnostics.healthcenter.thread.collection.interval", "com.ibm.java.diagnostics.healthcenter.headless.files.to.keep", "com.ibm.java.diagnostics.healthcenter.agent.iiop.port", "com.ibm.java.diagnostics.healthcenter.headless.files.max.size", "com.ibm.java.diagnostics.healthcenter.headless.filename", "com.ibm.java.diagnostics.healthcenter.config", "com.ibm.java.diagnostics.healthcenter.agent.path"};
    private static final Set<String> hcPropertyKeySet = new HashSet<String>();
    private Properties props = null;
    private DataCollectionLevel level = null;
    private String agentPath = null;

    public HealthCenterOptionHandler(Logger logger) {
        this.logger = logger;
    }

    public HealthCenterOptionHandler(String[] args) {
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
        String pidString = args != null && args.length > 0 ? args[0] : System.getProperty("sun.java.launcher.pid");
        try {
            this.pid = Integer.parseInt(pidString);
            AgentLogFactory.setPid(this.pid);
        }
        catch (Throwable e) {
            this.logger.fine(MessageFormat.format(Messages.getString("HCLaunchMBean.invalid.process.id"), pidString));
        }
        if (args != null && args.length > 1) {
            this.processArg(args[1]);
        }
        this.populateProperties();
    }

    private void processArg(String argString) {
        int propIndex = argString.indexOf("<?xml");
        if (propIndex < 0) {
            this.processOptions(argString);
        } else {
            this.processOptions(argString.substring(0, propIndex));
            Properties hcProps = this.processProperties(argString.substring(propIndex));
            this.setSystemProperties(hcProps);
        }
    }

    private void setSystemProperties(Properties hcProps) {
        if (null == hcProps) {
            return;
        }
        Enumeration<Object> hcPropKeys = hcProps.keys();
        while (hcPropKeys.hasMoreElements()) {
            String hcPropKey = (String)hcPropKeys.nextElement();
            System.setProperty(hcPropKey, hcProps.getProperty(hcPropKey));
        }
    }

    private void processOptions(String optString) {
        String[] agentArgumentsArray;
        for (String argument : agentArgumentsArray = optString.split(",")) {
            if ((argument = argument.trim()).length() == 0) continue;
            this.agentArguments.add(argument);
        }
    }

    public static String processOption(String arg, String optKey) {
        String[] argsplit = arg.split("[:=]", 2);
        if (argsplit.length == 2 && argsplit[0].equals(optKey) && argsplit[1].length() != 0) {
            return argsplit[1];
        }
        return null;
    }

    public boolean validateOptions(String optString) {
        this.processOptions(optString);
        boolean optsOK = true;
        for (String option : this.agentArguments) {
            boolean opt_ok = true;
            String[] optsplit = option.split("[:=]", 2);
            if (optsplit.length == 1) {
                opt_ok = false;
                for (String keyword : hcUnitaryOptions) {
                    if (!option.equals(keyword)) continue;
                    opt_ok = true;
                    break;
                }
            } else if (optsplit[1].length() != 0) {
                String optname = optsplit[0];
                String optval = optsplit[1];
                String optupper = optval.toUpperCase();
                if (optname.equals(PORT_ARGUMENT)) {
                    opt_ok = HealthCenterOptionHandler.checkNumberRange(optval, 0, 65535);
                } else if (optname.equals(LEVEL_ARGUMENT)) {
                    try {
                        DataCollectionLevel.valueOf(optupper);
                    }
                    catch (IllegalArgumentException iae) {
                        opt_ok = false;
                    }
                } else if (optname.equals(TRANSPORT_ARGUMENT)) {
                    try {
                        TransportType.valueOf(optupper);
                    }
                    catch (IllegalArgumentException iae) {
                        opt_ok = false;
                    }
                } else {
                    opt_ok = optname.equals(PATH_ARGUMENT) ? HealthCenterOptionHandler.checkDir(optval) : false;
                }
            } else {
                opt_ok = false;
            }
            if (opt_ok) continue;
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", option);
            optsOK = false;
        }
        return optsOK;
    }

    private Properties processProperties(String propString) {
        try {
            ByteArrayInputStream hcPropInput = new ByteArrayInputStream(propString.getBytes("UTF-8"));
            Properties hcProps = new Properties();
            hcProps.loadFromXML(hcPropInput);
            return hcProps;
        }
        catch (Exception e) {
            HealthCenterOptionHandler.logSevere(this.logger, "HCLaunchMBean.error.exception", e.toString());
            return null;
        }
    }

    public static boolean validateHCProperties(Properties hcProps, Logger logger) {
        boolean propsOK = true;
        Enumeration<Object> hcPropKeys = hcProps.keys();
        while (hcPropKeys.hasMoreElements()) {
            String hcPropKey = (String)hcPropKeys.nextElement();
            boolean prop_ok = false;
            if (hcPropKey.startsWith("com.ibm.diagnostics.healthcenter") || hcPropKey.startsWith("com.ibm.java.diagnostics.healthcenter")) {
                prop_ok = true;
                continue;
            }
            if (hcPropertyKeySet.contains(hcPropKey)) {
                String hcPropValue = hcProps.getProperty(hcPropKey);
                String hcPropUpper = hcPropValue.toUpperCase();
                if (hcPropKey.equals("com.ibm.java.diagnostics.healthcenter.agent.debug")) {
                    prop_ok = HealthCenterOptionHandler.checkTrue(hcPropUpper);
                } else if (hcPropKey.equals(DEFAULT_TRACE_OVERRIDE_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkTrue(hcPropUpper);
                } else if (hcPropKey.equals(NODYNAMIC_TRACE_OVERRIDE_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkTrue(hcPropUpper);
                } else if (hcPropKey.equals(DATA_COLLECTION_LEVEL_PROPERTY)) {
                    try {
                        DataCollectionLevel.valueOf(hcPropUpper);
                    }
                    catch (IllegalArgumentException iae) {
                        prop_ok = false;
                    }
                } else if (hcPropKey.equals(MAX_CIRCULAR_BUFFER_SIZE_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(STACK_TRACE_DEPTH)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(ALLOCATION_THRESHOLD_LOW)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(ALLOCATION_THRESHOLD_HIGH)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(CONFIG_LOCATION_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkFile(hcPropValue);
                } else if (hcPropKey.equals(AUTHENTICATION_LOCATION_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkFile(hcPropValue);
                } else if (hcPropKey.equals(AUTHORIZATION_LOCATION_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkFile(hcPropValue);
                } else if (hcPropKey.equals(START_DELAY_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(CLEAR_BUILDER_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkTrue(hcPropUpper);
                } else if (hcPropKey.equals(USE_PLATFORM_MBEANSERVER_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkTrue(hcPropUpper);
                } else if (hcPropKey.equals(AGENT_PORT_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, 65535);
                } else if (hcPropKey.equals(HEADLESS_OUTPUT_DIRECTORY_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkDir(hcPropValue);
                } else if (hcPropKey.equals(HealthCenterOptionHandler.getAgentTransportProperty())) {
                    try {
                        TransportType.valueOf(hcPropUpper);
                    }
                    catch (IllegalArgumentException iae) {
                        prop_ok = false;
                    }
                } else if (hcPropKey.equals(SSL_KEYSTORE_LOCATION_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkFile(hcPropValue);
                } else if (hcPropKey.equals(SSL_KEYSTORE_PASSWORD_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkPassword(hcPropValue);
                } else if (hcPropKey.equals(SSL_KEYSTORE_CERTIFICATE_PASSWORD_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkPassword(hcPropValue);
                } else if (hcPropKey.equals(SSL_TRUSTSTORE_LOCATION_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkFile(hcPropValue);
                } else if (hcPropKey.equals(SSL_TRUSTSTORE_PASSWORD_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkPassword(hcPropValue);
                } else if (hcPropKey.equals(SSL_TRUSTSTORE_CERTIFICATE_PASSWORD_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkPassword(hcPropValue);
                } else if (hcPropKey.equals(HEADLESS_START_DELAY)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(HEADLESS_RUN_DURATION)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(HEADLESS_RUN_PAUSE_DURATION)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(HEADLESS_RUN_NUMBER_OF_RUNS)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(THREAD_COLLECTION_INTERVAL)) {
                    prop_ok = HealthCenterOptionHandler.checkNumberRange(hcPropValue, 0, -1);
                } else if (hcPropKey.equals(CONFIG_OVERRIDE_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkDir(hcPropValue);
                } else if (hcPropKey.equals(AGENT_PATH_PROPERTY)) {
                    prop_ok = HealthCenterOptionHandler.checkDir(hcPropValue);
                }
                if (prop_ok) continue;
                if (logger != null) {
                    HealthCenterOptionHandler.logWarning(logger, "HCLaunchMBean.invalid.value", hcPropValue, hcPropKey);
                }
                propsOK = false;
                continue;
            }
            if (logger != null) {
                HealthCenterOptionHandler.logWarning(logger, "HCLaunchMBean.unknown.property", hcPropKey);
            }
            propsOK = false;
        }
        return propsOK;
    }

    private static boolean checkNumberRange(String numstr, int lower, int upper) {
        boolean num_ok = true;
        try {
            Integer num = Integer.parseInt(numstr);
            int numval = num;
            if (numval < lower) {
                num_ok = false;
            }
            if (upper >= lower && numval > upper) {
                num_ok = false;
            }
        }
        catch (NumberFormatException nfe) {
            num_ok = false;
        }
        return num_ok;
    }

    private static boolean checkTrue(String str) {
        return str.equals(TRUE.toUpperCase());
    }

    private static boolean checkFile(String filename) {
        return HealthCenterOptionHandler.checkFileDir(filename, true);
    }

    private static boolean checkDir(String filename) {
        return HealthCenterOptionHandler.checkFileDir(filename, false);
    }

    private static boolean checkFileDir(String filename, boolean checkfile) {
        try {
            File file = new File(filename);
            if (file.exists() && (checkfile ? file.isFile() : file.isDirectory())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean checkPassword(String str) {
        return true;
    }

    public int getPid() {
        return this.pid;
    }

    public boolean isDynamicOverride() {
        for (String argument : this.agentArguments) {
            if (!argument.trim().equals(DYNAMIC_TRACE)) continue;
            this.setProperty(NODYNAMIC_TRACE_OVERRIDE_PROPERTY, TRUE);
            return true;
        }
        String property = this.findProperty(NODYNAMIC_TRACE_OVERRIDE_PROPERTY);
        return property != null;
    }

    public String getAgentPath() {
        if (this.agentPath != null) {
            return this.agentPath;
        }
        for (String argument : this.agentArguments) {
            this.agentPath = HealthCenterOptionHandler.processOption(argument, PATH_ARGUMENT);
            if (this.agentPath == null) continue;
            File apFile = new File(this.agentPath);
            File jrePath = new File(this.agentPath, JRE);
            if (HealthCenterOptionHandler.checkDir(jrePath.getAbsolutePath())) {
                this.agentPath = jrePath.getAbsolutePath();
                this.setProperty(AGENT_PATH_PROPERTY, this.agentPath);
                return this.agentPath;
            }
            if (HealthCenterOptionHandler.checkDir(apFile.getAbsolutePath())) {
                this.agentPath = apFile.getAbsolutePath();
                this.setProperty(AGENT_PATH_PROPERTY, this.agentPath);
                return this.agentPath;
            }
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", "path=" + this.agentPath);
            this.agentPath = null;
        }
        this.agentPath = System.getProperty(AGENT_PATH_PROPERTY);
        if (this.agentPath != null) {
            File apFile = new File(this.agentPath);
            File jrePath = new File(this.agentPath, JRE);
            if (HealthCenterOptionHandler.checkDir(jrePath.getAbsolutePath())) {
                this.agentPath = jrePath.getAbsolutePath();
                this.setProperty(AGENT_PATH_PROPERTY, this.agentPath);
                return this.agentPath;
            }
            if (HealthCenterOptionHandler.checkDir(apFile.getAbsolutePath())) {
                this.agentPath = apFile.getAbsolutePath();
                this.setProperty(AGENT_PATH_PROPERTY, this.agentPath);
                return this.agentPath;
            }
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", "path=" + this.agentPath);
            this.agentPath = null;
        }
        return this.agentPath;
    }

    public DataCollectionLevel getDataCollectionLevel() {
        if (this.level != null) {
            return this.level;
        }
        for (String argument : this.agentArguments) {
            String levelString = HealthCenterOptionHandler.processOption(argument, LEVEL_ARGUMENT);
            if (levelString == null) continue;
            this.level = this.getLevelFromString(levelString);
            this.setProperty(DATA_COLLECTION_LEVEL_PROPERTY, this.level.name());
            return this.level;
        }
        String property = this.findProperty(DATA_COLLECTION_LEVEL_PROPERTY);
        if (property != null) {
            this.level = this.getLevelFromString(property);
            return this.level;
        }
        this.level = DataCollectionLevel.FULL;
        this.setProperty(DATA_COLLECTION_LEVEL_PROPERTY, this.level.name());
        return this.level;
    }

    private DataCollectionLevel getLevelFromString(String levelString) {
        DataCollectionLevel level;
        String uppercaseLevelString = levelString.toUpperCase();
        try {
            level = DataCollectionLevel.valueOf(uppercaseLevelString);
        }
        catch (IllegalArgumentException e) {
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.level", levelString);
            level = DataCollectionLevel.FULL;
        }
        return level;
    }

    private EventCollectionLevel getEventFromString(String eventString) {
        EventCollectionLevel event;
        String uppercaseEventString = eventString.toUpperCase();
        try {
            event = EventCollectionLevel.valueOf(uppercaseEventString);
        }
        catch (IllegalArgumentException e) {
            HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.event", eventString);
            event = null;
        }
        return event;
    }

    private void populateProperties() {
        String usePlatMBeanProp;
        String clearBuilderProp;
        String timeout = this.findProperty(START_DELAY_PROPERTY);
        if (timeout != null) {
            try {
                this.startDelaySeconds = new Integer(timeout);
                String template = Messages.getString("HCLaunchMBean.start.delay.overridden");
                String message = MessageFormat.format(template, START_DELAY_PROPERTY, this.startDelaySeconds);
                this.logger.config(message);
            }
            catch (Throwable e) {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.integer", START_DELAY_PROPERTY, timeout);
            }
        }
        if ((clearBuilderProp = this.findProperty(CLEAR_BUILDER_PROPERTY)) != null && clearBuilderProp.equals(TRUE)) {
            this.tryOverrideBuilder = true;
            this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.override"), CLEAR_BUILDER_PROPERTY, JMX_BUILDER_PROPERTY));
        }
        if ((usePlatMBeanProp = this.findProperty(USE_PLATFORM_MBEANSERVER_PROPERTY)) != null && usePlatMBeanProp.equals(TRUE)) {
            this.usePlatformMBeanServer = true;
            String message = MessageFormat.format(Messages.getString("HCLaunchMBean.using.platform.mbean.server"), USE_PLATFORM_MBEANSERVER_PROPERTY);
            this.logger.config(message);
        }
        this.workOutStartPort();
        this.autheFile = this.findProperty(AUTHENTICATION_LOCATION_PROPERTY);
        this.authoFile = this.findProperty(AUTHORIZATION_LOCATION_PROPERTY);
        this.sslKeystore = this.findProperty(SSL_KEYSTORE_LOCATION_PROPERTY);
        this.sslKeystorePassword = this.findProperty(SSL_KEYSTORE_PASSWORD_PROPERTY);
        this.sslKeystoreCertificatePassword = this.findProperty(SSL_KEYSTORE_CERTIFICATE_PASSWORD_PROPERTY);
        this.sslTruststore = this.findProperty(SSL_TRUSTSTORE_LOCATION_PROPERTY);
        this.sslTruststorePassword = this.findProperty(SSL_TRUSTSTORE_PASSWORD_PROPERTY);
        this.sslTruststoreCertificatePassword = this.findProperty(SSL_TRUSTSTORE_CERTIFICATE_PASSWORD_PROPERTY);
    }

    private void workOutStartPort() {
        Iterator<String> it = this.agentArguments.iterator();
        boolean foundPort = false;
        while (it.hasNext()) {
            String argument = it.next();
            String portString = HealthCenterOptionHandler.processOption(argument, PORT_ARGUMENT);
            if (portString == null) continue;
            try {
                if (HealthCenterOptionHandler.checkNumberRange(portString, 0, 65535)) {
                    this.startPort = Integer.parseInt(portString);
                    foundPort = true;
                    continue;
                }
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", argument);
            }
            catch (Throwable e) {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.integer", PORT_ARGUMENT, portString);
            }
        }
        if (foundPort) {
            this.setProperty(AGENT_PORT_PROPERTY, Integer.toString(this.startPort));
        } else {
            String tempPortOverride = this.findProperty(AGENT_PORT_PROPERTY);
            if (tempPortOverride != null) {
                try {
                    if (HealthCenterOptionHandler.checkNumberRange(tempPortOverride, 0, 65535)) {
                        this.startPort = Integer.parseInt(tempPortOverride);
                        this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.overriding.start.port"), AGENT_PORT_PROPERTY, this.startPort));
                    } else {
                        HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.value", tempPortOverride, AGENT_PORT_PROPERTY);
                    }
                }
                catch (Throwable e) {
                    HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.integer", AGENT_PORT_PROPERTY, tempPortOverride);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getHealthCenterProperties() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Requested health center properties.");
        }
        if (this.props == null) {
            File libDirectory;
            File confDirectory;
            String remotePath;
            File propsFile = null;
            String fileName = System.getProperty(CONFIG_LOCATION_PROPERTY);
            if (fileName != null) {
                propsFile = new File(fileName);
            }
            if (propsFile == null || !propsFile.exists()) {
                propsFile = new File(HEALTHCENTER_PROPERTIES_FILE_NAME);
            }
            if (!(propsFile != null && propsFile.exists() || (remotePath = this.getAgentPath()) == null)) {
                if (Util.getJavaLevel() >= 11) {
                    confDirectory = new File(remotePath, CONF);
                    propsFile = new File(confDirectory, HEALTHCENTER_PROPERTIES_FILE_NAME);
                } else {
                    libDirectory = new File(remotePath, LIB);
                    propsFile = new File(libDirectory, HEALTHCENTER_PROPERTIES_FILE_NAME);
                }
            }
            if (propsFile == null || !propsFile.exists()) {
                String javaHome = System.getProperty(JAVA_HOME);
                if (Util.getJavaLevel() >= 11) {
                    confDirectory = new File(javaHome, CONF);
                    propsFile = new File(confDirectory, HEALTHCENTER_PROPERTIES_FILE_NAME);
                } else {
                    libDirectory = new File(javaHome, LIB);
                    propsFile = new File(libDirectory, HEALTHCENTER_PROPERTIES_FILE_NAME);
                }
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, MessageFormat.format("Loading health center properties from {0}.", propsFile.getAbsolutePath()));
            }
            if (propsFile.exists() && propsFile.canRead()) {
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(propsFile);
                    this.props = new Properties();
                    this.props.load(stream);
                }
                catch (Exception e) {
                    HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.could.not.load.properties", propsFile.getAbsolutePath());
                }
                finally {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException ie) {}
                }
            } else {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.bad.properties.file", propsFile.getAbsolutePath());
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String message = MessageFormat.format("Returning health center properties {0}", this.props);
            this.logger.log(Level.FINER, message);
        }
        return this.props;
    }

    private String findProperty(String key) {
        if (this.logger.isLoggable(Level.FINER)) {
            String message = MessageFormat.format("Requested {0} property.", key);
            this.logger.log(Level.FINER, message);
        }
        String value = System.getProperty(key);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, MessageFormat.format("{0} property is {1} in system properties.", key, value));
        }
        if (value == null) {
            Properties props;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, MessageFormat.format("Requesting {0} from health center properties.", key));
            }
            if ((props = this.getHealthCenterProperties()) != null) {
                value = props.getProperty(key);
                if (this.logger.isLoggable(Level.FINEST)) {
                    String template = "Health center properties existed and {0} was {1}.";
                    String message = MessageFormat.format("Health center properties existed and {0} was {1}.", key, value);
                    this.logger.log(Level.FINEST, message);
                }
                if (value != null && value.length() != 0) {
                    this.setProperty(key, value);
                }
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String template = "Returning {0} for {1} property.";
            String message = MessageFormat.format("Returning {0} for {1} property.", value, key);
            this.logger.log(Level.FINER, message);
        }
        return value;
    }

    private void setProperty(String key, String value) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, MessageFormat.format("Setting Health Center System property {0} with value {1}.", key, value));
        }
        System.setProperty(key, value);
    }

    public String getAutheFile() {
        return this.autheFile;
    }

    public String getAuthoFile() {
        return this.authoFile;
    }

    public String getSslKeystore() {
        return this.sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public String getSslKeystoreCertificatePassword() {
        if (this.sslKeystoreCertificatePassword == null) {
            return this.getSslKeystorePassword();
        }
        return this.sslKeystoreCertificatePassword;
    }

    public String getSslTruststore() {
        if (this.sslTruststore == null) {
            return this.getSslKeystore();
        }
        return this.sslTruststore;
    }

    public String getSslTruststorePassword() {
        if (this.sslTruststorePassword == null) {
            return this.getSslKeystorePassword();
        }
        return this.sslTruststorePassword;
    }

    public String getSslTruststoreCertificatePassword() {
        if (this.sslTruststoreCertificatePassword == null) {
            if (this.sslTruststorePassword == null) {
                return this.getSslKeystoreCertificatePassword();
            }
            return this.getSslTruststorePassword();
        }
        return this.sslTruststoreCertificatePassword;
    }

    public int getStartDelaySeconds() {
        return this.startDelaySeconds;
    }

    public boolean isTryOverrideBuilder() {
        return this.tryOverrideBuilder;
    }

    public boolean isUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public String getMaxCircularBufferSize() {
        return this.findProperty(MAX_CIRCULAR_BUFFER_SIZE_PROPERTY);
    }

    public boolean isKeepAlive() {
        for (String argument : this.agentArguments) {
            if (!KEEP_ALIVE.equals(argument)) continue;
            return true;
        }
        return false;
    }

    public String[] getVMArgs() {
        String[] arguments = null;
        if (!System.getProperty("java.vm.vendor").contains("IBM")) {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            arguments = (String[])runtimeMxBean.getInputArguments().toArray();
        } else {
            try {
                Class[] noparams = new Class[]{};
                Class<?> vmClass = Class.forName("com.ibm.oti.vm.VM");
                Object vmObj = vmClass.newInstance();
                Method vmMethod = vmClass.getDeclaredMethod("getVMArgs", noparams);
                arguments = (String[])vmMethod.invoke(vmObj, (Object[])null);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return arguments;
    }

    public boolean shouldDisableDefaultTrace() {
        for (String argument : this.agentArguments) {
            if (!KEEP_DEFAULT_TRACE.equals(argument)) continue;
            this.setProperty(DEFAULT_TRACE_OVERRIDE_PROPERTY, TRUE);
            return false;
        }
        String property = this.findProperty(DEFAULT_TRACE_OVERRIDE_PROPERTY);
        return property == null;
    }

    public void setDataCollectionLevel(DataCollectionLevel setlevel) {
        this.level = setlevel;
    }

    public String getStackTraceDepth() {
        return this.findProperty(STACK_TRACE_DEPTH);
    }

    public int getThreadStackDepth() {
        try {
            int stackDepth = new Integer(this.findProperty(THREAD_STACK_DEPTH));
            return stackDepth;
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public String getLowAllocationThreshold() {
        return this.findProperty(ALLOCATION_THRESHOLD_LOW);
    }

    public String getHighAllocationThreshold() {
        return this.findProperty(ALLOCATION_THRESHOLD_HIGH);
    }

    public String getHeadlessOutputDirectory() {
        String dir = this.findProperty(HEADLESS_OUTPUT_DIRECTORY_PROPERTY);
        if (dir == null || dir.length() == 0) {
            dir = this.findProperty(OUTPUT_DIRECTORY_PROPERTY);
        }
        return dir;
    }

    public String getHeadlessFileName() {
        return this.findProperty(HEADLESS_USER_FILE_NAME);
    }

    public String getOutputDirectory() {
        String dir = this.findProperty(OUTPUT_DIRECTORY_PROPERTY);
        if (dir == null || dir.length() == 0) {
            dir = this.findProperty(HEADLESS_OUTPUT_DIRECTORY_PROPERTY);
        }
        return dir;
    }

    public int getHeadlessStartDelay() {
        try {
            int hSD = new Integer(this.findProperty(HEADLESS_START_DELAY));
            return hSD;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getHeadlessRunPauseDuration() {
        try {
            int rPD = new Integer(this.findProperty(HEADLESS_RUN_PAUSE_DURATION));
            return rPD;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getHeadlessRunDuration() {
        try {
            int rD = new Integer(this.findProperty(HEADLESS_RUN_DURATION));
            return rD;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getHeadlessRunCount() {
        try {
            int rNOR = new Integer(this.findProperty(HEADLESS_RUN_NUMBER_OF_RUNS));
            return rNOR;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getFilesToKeep() {
        try {
            int rNOR = new Integer(this.findProperty(HEADLESS_RUN_FILES_TO_KEEP));
            return rNOR;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getMaxHeadlessFileSize() {
        try {
            int fileSize = new Integer(this.findProperty(HEADLESS_MAX_FILE_SIZE));
            return fileSize;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public int getTheadCollectionInterval() {
        try {
            int rNOR = new Integer(this.findProperty(THREAD_COLLECTION_INTERVAL));
            if (rNOR == 0) {
                rNOR = 30;
            }
            return rNOR;
        }
        catch (NumberFormatException e) {
            return 30;
        }
    }

    public TransportType getTransportType() {
        for (String argument : this.agentArguments) {
            String transportValueString = HealthCenterOptionHandler.processOption(argument, TRANSPORT_ARGUMENT);
            if (transportValueString == null) continue;
            try {
                TransportType type = TransportType.valueOf(transportValueString.toUpperCase());
                this.setProperty(HealthCenterOptionHandler.getAgentTransportProperty(), type.name());
                return type;
            }
            catch (IllegalArgumentException iae) {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.argument", argument);
            }
        }
        String transport = this.findProperty(HealthCenterOptionHandler.getAgentTransportProperty());
        if (transport != null) {
            try {
                TransportType type = TransportType.valueOf(transport.toUpperCase());
                return type;
            }
            catch (IllegalArgumentException iae) {
                HealthCenterOptionHandler.logWarning(this.logger, "HCLaunchMBean.invalid.value", transport, HealthCenterOptionHandler.getAgentTransportProperty());
            }
        }
        TransportType type = TransportType.IIOP;
        this.setProperty(HealthCenterOptionHandler.getAgentTransportProperty(), type.name());
        return type;
    }

    private static void logWarning(Logger logger, String msgID, Object ... inserts) {
        HealthCenterOptionHandler.logMessage(logger, Level.WARNING, msgID, inserts);
    }

    private static void logSevere(Logger logger, String msgID, Object ... inserts) {
        HealthCenterOptionHandler.logMessage(logger, Level.SEVERE, msgID, inserts);
    }

    private static void logMessage(Logger logger, Level level, String msgID, Object ... inserts) {
        if (logger.isLoggable(level)) {
            String template = Messages.getString(msgID);
            String warning = MessageFormat.format(template, inserts);
            logger.log(level, warning);
        }
    }

    public void setAgentPort(int port) {
        if (port >= 0) {
            this.startPort = port;
            this.setProperty(AGENT_PORT_PROPERTY, Integer.toString(port));
        }
    }

    public static String getAgentTransportProperty() {
        return AGENT_TRANSPORT_PROPERTY;
    }

    public String getAgentIIOPPort() {
        return this.findProperty(AGENT_IIOP_PORT_PROPERTY);
    }

    public static String[] getProperties(String[] args) {
        HealthCenterOptionHandler handler = new HealthCenterOptionHandler(args);
        handler.getDataCollectionLevel();
        handler.getTransportType();
        handler.isDynamicOverride();
        handler.shouldDisableDefaultTrace();
        handler.getAgentPath();
        Properties p = new Properties();
        Properties hcProps = handler.getHealthCenterProperties();
        if (hcProps != null) {
            p.putAll((Map<?, ?>)handler.getHealthCenterProperties());
        }
        p.putAll((Map<?, ?>)System.getProperties());
        p.put("com.ibm.diagnostics.healthcenter.capability.isRealTimeVM", String.valueOf(Util.isRealTimeVM()));
        p.put("com.ibm.diagnostics.healthcenter.capability.canGetThreads", String.valueOf(Util.canGetThreads()));
        p.put("com.ibm.diagnostics.healthcenter.capability.is26VMOrLater", String.valueOf(Util.is26VMOrLater()));
        p.put("com.ibm.diagnostics.healthcenter.capability.JavaLevel", String.valueOf(Util.getJavaLevel()));
        p.put("com.ibm.diagnostics.healthcenter.capability.ServiceRefreshNumber", String.valueOf(Util.getServiceRefreshNumber()));
        p.put("com.ibm.diagnostics.healthcenter.capability.FixpackNumber", String.valueOf(Util.getFixpackNumber()));
        p.put("com.ibm.diagnostics.healthcenter.capability.VMVersion", Util.getVMVersionString());
        p.put("com.ibm.diagnostics.healthcenter.capability.is26VMOrLater", String.valueOf(Util.is26VMOrLater()));
        p.put("com.ibm.diagnostics.healthcenter.capability.is27VMOrLater", String.valueOf(Util.is27VMOrLater()));
        p.put("com.ibm.diagnostics.healthcenter.capability.isHardRealTimeVM", String.valueOf(Util.isHardRealTimeVM()));
        p.put("com.ibm.diagnostics.healthcenter.capability.isRealTimeVM", String.valueOf(Util.isRealTimeVM()));
        p.put("com.ibm.diagnostics.healthcenter.capability.j9DmpTrcAvailable", String.valueOf(Util.j9DmpTrcAvailable()));
        p.put("com.ibm.diagnostics.healthcenter.capability.vmHasJ9MethodLookup", String.valueOf(Util.vmHasJ9MethodLookup()));
        p.put("com.ibm.diagnostics.healthcenter.capability.vmHasLOATracePoints", String.valueOf(Util.vmHasLOATracePoints()));
        Enumeration<?> e = p.propertyNames();
        String[] propsArray = new String[p.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            String prop;
            String key = (String)e.nextElement();
            propsArray[i] = prop = key + "=" + p.getProperty(key);
            ++i;
        }
        return propsArray;
    }

    static {
        for (String hcPropertyKey : hcPropertyKeys) {
            hcPropertyKeySet.add(hcPropertyKey);
        }
    }
}

