/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static String runtimeVersion = System.getProperty("java.runtime.version");
    private static String specVersion = System.getProperty("java.specification.version");
    private static String vmVersion = System.getProperty("java.vm.version");
    private static String fullVersion = System.getProperty("java.fullversion");
    private static String osName = System.getProperty("os.name");
    private static final String REALTIME_IDENTIFIER = "real-time";
    private static final String SOFT_REALTIME_IDENTIFER = "srt";
    private static final String ZOS = "z/OS";
    private static final int JAVA6_SR4 = 20090330;
    private static final int JAVA5_SR10 = 20090601;
    private static final int JAVA626_SR1 = 20110921;
    private static final Pattern VM_DATE_PATTERN = Pattern.compile("(.*)(\\d{8})(.*)");
    private static final String BLANK = "";

    public static void overrideJavaVersion(String spec, String vm) {
        specVersion = spec;
        runtimeVersion = vm;
    }

    public static boolean isIBM() {
        String vendor = System.getProperty("java.vm.vendor");
        return vendor.contains("IBM") || vendor.contains("OpenJ9");
    }

    public static boolean isRealTimeVM() {
        if (!Util.isIBM()) {
            return false;
        }
        if (System.getProperty("com.ibm.jvm.realtime") != null) {
            return System.getProperty("com.ibm.jvm.realtime").contains("hard");
        }
        return false;
    }

    public static boolean isHardRealTimeVM() {
        if (!Util.isIBM()) {
            return false;
        }
        if (fullVersion.contains(REALTIME_IDENTIFIER) && !fullVersion.contains(SOFT_REALTIME_IDENTIFER)) {
            return true;
        }
        if (System.getProperty("com.ibm.jvm.realtime") != null) {
            return System.getProperty("com.ibm.jvm.realtime").contains("hard");
        }
        return false;
    }

    public static boolean vmHasLOATracePoints() {
        if (Util.isIBM()) {
            if (Util.getJavaLevel() > 6) {
                return true;
            }
            String date = Util.getVMLevel(fullVersion);
            int vmDate = Util.convertStringDateToInt(date);
            if (Util.getJavaLevel() == 6 && vmDate > 20090330) {
                return true;
            }
            if (Util.getJavaLevel() == 5 && vmDate >= 20090601) {
                return true;
            }
        }
        return false;
    }

    public static boolean vmHasJ9MethodLookup() {
        if (Util.isIBM()) {
            if (Util.is27VMOrLater()) {
                return true;
            }
            String date = Util.getVMLevel(fullVersion);
            int vmDate = Util.convertStringDateToInt(date);
            return Util.is26VMOrLater() && vmDate >= 20110921;
        }
        return false;
    }

    public static boolean j9DmpTrcAvailable() {
        if (Util.isIBM()) {
            if (Util.is27VMOrLater()) {
                return true;
            }
            String date = Util.getVMLevel(fullVersion);
            int vmDate = Util.convertStringDateToInt(date);
            if (Util.is26VMOrLater()) {
                return vmDate >= 20110921 || Util.getJavaLevel() == 7;
            }
            return false;
        }
        return false;
    }

    public static boolean canGetThreads() {
        if (Util.is27VMOrLater()) {
            return true;
        }
        if (fullVersion != null) {
            String date = Util.getVMLevel(fullVersion);
            int vmDate = Util.convertStringDateToInt(date);
            if (Util.is26VMOrLater()) {
                return vmDate >= 20110921;
            }
            return true;
        }
        return false;
    }

    public static boolean is26VMOrLater() {
        return Util.isIBM() && Util.getVMVersion() >= 2.6f;
    }

    public static boolean is27VMOrLater() {
        return Util.isIBM() && Util.getVMVersion() >= 2.7f;
    }

    private static int convertStringDateToInt(String date) {
        int ret = 0;
        try {
            ret = Integer.parseInt(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private static String getVMLevel(String fullversion) {
        int requiredGroup = 2;
        String date = BLANK;
        Matcher m = VM_DATE_PATTERN.matcher(fullversion);
        if (m.find() && m.groupCount() >= 3) {
            date = m.group(2);
        }
        return date;
    }

    public static boolean isOkConsideringRealtime(int tp) {
        boolean answer = Util.isRealTimeVM() ? (Util.is26VMOrLater() ? tp == 285 || tp == 286 || tp == 467 || tp == 468 || tp == 474 || tp == 475 || tp >= 54 && tp <= 57 : tp >= 279 && tp <= 282) : tp != 285 && tp != 286 && tp != 467 && tp != 468 && (tp < 279 || tp > 282);
        return answer;
    }

    public static int getJavaLevel() {
        int level = -1;
        String[] versions = specVersion.split("\\.");
        if (versions.length >= 2) {
            try {
                level = Integer.parseInt(versions[1]);
            }
            catch (NumberFormatException e) {}
        } else if (versions.length == 1) {
            try {
                level = Integer.parseInt(versions[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return level;
    }

    public static int getServiceRefreshNumber() {
        int sr = -1;
        Pattern pat = Pattern.compile("(.*\\([SE][RA])(\\d+)(.*)");
        Matcher mat = pat.matcher(runtimeVersion);
        if (mat.matches() && mat.groupCount() > 2) {
            try {
                sr = Integer.parseInt(mat.group(2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sr;
    }

    public static int getFixpackNumber() {
        int fp = -1;
        Pattern pat = Pattern.compile("(.*\\([SE][RA])(\\d+) [Ff][Pp](\\d+)(.*)");
        Matcher mat = pat.matcher(runtimeVersion);
        if (mat.matches() && mat.groupCount() > 3) {
            try {
                fp = Integer.parseInt(mat.group(3));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fp;
    }

    public static String getVMVersionString() {
        return vmVersion;
    }

    public static float getVMVersion() {
        float vmVersionFloat = -1.0f;
        if (vmVersion != null) {
            try {
                vmVersionFloat = Float.parseFloat(vmVersion);
            }
            catch (NumberFormatException e) {
                if (Util.isIBM() && Util.getJavaLevel() >= 11) {
                    return 2.9f;
                }
                e.printStackTrace();
            }
        }
        return vmVersionFloat;
    }

    public static String findWriteableDirectory(String directory) {
        if (Util.canWrite(directory)) {
            return directory;
        }
        String dir = System.getProperty("user.dir");
        if (Util.canWrite(dir)) {
            return dir;
        }
        dir = BLANK;
        if (Util.canWrite(dir)) {
            return dir;
        }
        dir = System.getProperty("java.io.tmpdir");
        if (Util.canWrite(dir)) {
            return dir;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(String dir) {
        if (dir != null) {
            File directory = new File(dir);
            if (!directory.isDirectory()) {
                return false;
            }
            int suffix = 0;
            File testFile = new File(directory, "hctest_" + suffix);
            while (testFile.exists()) {
                testFile = new File(directory, "hctest_" + ++suffix);
            }
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(testFile);
                }
                catch (FileNotFoundException e) {
                    boolean bl = false;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        if (testFile.exists()) {
                            try {
                                testFile.delete();
                            }
                            catch (SecurityException e3) {
                                // empty catch block
                            }
                        }
                    }
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                    if (testFile.exists()) {
                        try {
                            testFile.delete();
                        }
                        catch (SecurityException e) {}
                    }
                }
            }
        }
        return false;
    }

    public static boolean isZOS() {
        return osName.contains(ZOS);
    }
}

