/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPublicKey;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.x509.AlgorithmId;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public abstract class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a;
    static int b;
    static int c;
    private int d = 2048;
    SecureRandom e = null;
    private RSAUtil.KeyType f = RSAUtil.KeyType.RSA;
    private AlgorithmId g;
    private static final String[] z;

    RSAKeyPairGenerator(RSAUtil.KeyType keyType, int n2) {
        this.f = keyType;
        this.initialize(n2, null);
    }

    RSAKeyPairGenerator(int n2) {
        this.f = RSAUtil.KeyType.RSA;
        this.initialize(n2, null);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec2;
        block19: {
            int n2;
            block18: {
                if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                    throw new InvalidAlgorithmParameterException(z[4]);
                }
                RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
                algorithmParameterSpec2 = rSAKeyGenParameterSpec.getKeyParams();
                n2 = rSAKeyGenParameterSpec.getKeysize();
                this.a = rSAKeyGenParameterSpec.getPublicExponent();
                this.e = secureRandom;
                if (n2 % 8 != 0) {
                    throw new InvalidAlgorithmParameterException(z[1]);
                }
                try {
                    RSAKeyFactory.checkKeyLengths(n2, this.a, 512, 65536);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidAlgorithmParameterException(z[2], invalidKeyException);
                }
                this.d = n2;
                if (this.a != null) break block18;
                this.a = RSAKeyGenParameterSpec.F4;
                break block19;
            }
            if (this.a.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException(z[5]);
            }
            if (this.a.bitLength() > n2) {
                throw new InvalidAlgorithmParameterException(z[3]);
            }
        }
        try {
            this.g = RSAUtil.createAlgorithmId((RSAUtil.KeyType)this.f, (AlgorithmParameterSpec)algorithmParameterSpec2);
        }
        catch (ProviderException providerException) {
            throw new InvalidAlgorithmParameterException(z[6], providerException);
        }
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        try {
            this.initialize(new RSAKeyGenParameterSpec(n2, RSAKeyGenParameterSpec.F4), null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        BigInteger bigInteger4;
        int n2;
        if (this.e == null) {
            this.e = null;
            try {
                this.e = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.e = new SecureRandom();
            }
        }
        BigInteger bigInteger7 = this.a != null ? this.a : RSAKeyGenParameterSpec.F4;
        while ((n2 = (bigInteger4 = (bigInteger6 = new BigInteger(this.d / 2, 10, this.e)).multiply(bigInteger5 = new BigInteger(this.d / 2, 10, this.e))).bitLength()) != this.d || !bigInteger7.gcd(bigInteger = (bigInteger3 = bigInteger6.subtract(BigInteger.ONE)).multiply(bigInteger2 = bigInteger5.subtract(BigInteger.ONE))).equals(BigInteger.ONE)) {
        }
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger3);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger2);
        BigInteger bigInteger11 = bigInteger5.modInverse(bigInteger6);
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(this.g, bigInteger4, bigInteger7);
            RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(this.g, bigInteger4, bigInteger8, bigInteger7, bigInteger6, bigInteger5, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[7];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "6N\u0000\u0012d\u001cy?$S\u001eb).l";
        int n3 = -1;
        block14: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                block17: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block17;
                    n5 = n5;
                    if (n5 <= n4) break block18;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 127;
                            break;
                        }
                        case 1: {
                            n6 = 12;
                            break;
                        }
                        case 2: {
                            n6 = 77;
                            break;
                        }
                        case 3: {
                            n6 = 65;
                            break;
                        }
                        default: {
                            n6 = 1;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "2c)4m\n\u007fm2h\u0005im,t\fxm#d_a8-u\u0016|!$!\u0010jmy";
                    n3 = 0;
                    continue block14;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "6b; m\u0016hm*d\u0006,>({\u001a\u007f";
                    n3 = 1;
                    continue block14;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "/y/-h\u001c,(9q\u0010b(/u_a82u_n(ar\u0012m!-d\r,9)`\u0011,&$x_\u007f$;d";
                    n3 = 2;
                    continue block14;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "/m? l\f, 4r\u000b,/$!\u0016b>5`\u0011o(an\u0019,\u001f\u0012@4i4\u0006d\u0011\\,3`\u0012i9$s,|(\"";
                    n3 = 3;
                    continue block14;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "/y/-h\u001c,(9q\u0010b(/u_a82u_n(a2_c?am\u001e~*$s";
                    n3 = 4;
                    continue block14;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "6b; m\u0016hm*d\u0006,= s\u001ea(5d\r\u007f";
                    n3 = 5;
                    continue block14;
                }
                case 5: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        b = 2048;
        c = 2048;
    }
}

