/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class PreferredSymmAlgInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.preferred_symm_alg_oid;
    private AlgorithmId value;
    private byte[] encodedValue;

    public PreferredSymmAlgInfoValue(AlgorithmId algorithmId) throws IOException {
        if (algorithmId == null) {
            throw new IllegalArgumentException("PreferredSymmAlgInfoValue error, algid not specified");
        }
        this.value = algorithmId;
        this.setEncodedValue();
    }

    public PreferredSymmAlgInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public Object clone() {
        try {
            return new PreferredSymmAlgInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        this.value = new AlgorithmId(derValue);
        this.setEncodedValue();
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(PreferredSymmAlgInfoValue preferredSymmAlgInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (preferredSymmAlgInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            preferredSymmAlgInfoValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PreferredSymmAlgInfoValue) {
            return this.equals((PreferredSymmAlgInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return (byte[])this.encodedValue.clone();
    }

    public String getName() {
        return "PreferredSymmAlg";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        AlgorithmId algorithmId = null;
        try {
            algorithmId = new AlgorithmId(this.value.getOID(), this.value.getParameters());
        }
        catch (IOException iOException) {
            return null;
        }
        return algorithmId;
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.value.encode(derOutputStream);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "PreferredSymmAlgInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\ncertificate:\r\n";
        string = object == null ? String.valueOf(string) + "no cert" : String.valueOf(string) + object.toString();
        return string;
    }
}

