/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.LocalMap;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class LocalMapCommand
extends Command {
    public LocalMapCommand() {
        this.addCommand("localmap", "<pc>", "calculate the local slot map for the specified PC");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            if (args.length != 1) {
                CommandUtils.dbgPrint(out, "bad or missing PC\n");
                return;
            }
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.J9VM_ENV_DATA64);
            U8Pointer pc = U8Pointer.cast(address);
            CommandUtils.dbgPrint(out, "Searching for PC=%d in VM=%s...\n", pc.longValue(), vm.getHexAddress());
            J9MethodPointer localMethod = J9JavaVMHelper.getMethodFromPC(vm, pc);
            if (localMethod.notNull()) {
                long methodIndex;
                int[] localMap = new int[2048];
                CommandUtils.dbgPrint(out, "Found method %s !j9method %s\n", J9MethodHelper.getName(localMethod), localMethod.getHexAddress());
                UDATA offsetPC = new UDATA(pc.sub(U8Pointer.cast(localMethod.bytecodes())));
                CommandUtils.dbgPrint(out, "Relative PC = %d\n", offsetPC.longValue());
                J9ClassPointer localClass = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(localMethod);
                CommandUtils.dbgPrint(out, "Method index is %d\n", methodIndex);
                J9ROMMethodPointer localROMMethod = this.J9ROMCLASS_ROMMETHODS(localClass.romClass());
                for (methodIndex = new UDATA(localMethod.sub(localClass.ramMethods())).longValue(); methodIndex != 0L; --methodIndex) {
                    localROMMethod = ROMHelp.nextROMMethod(localROMMethod);
                }
                CommandUtils.dbgPrint(out, "Using ROM method %s\n", localROMMethod.getHexAddress());
                U16 tempCount = localROMMethod.tempCount();
                U8 argCount = localROMMethod.argCount();
                long localCount = tempCount.add(argCount).longValue();
                if (localCount > 0L) {
                    int errorCode = LocalMap.j9localmap_LocalBitsForPC(localROMMethod, offsetPC, localMap);
                    if (errorCode != 0) {
                        CommandUtils.dbgPrint(out, "Local map failed, error code = %d\n", errorCode);
                    } else {
                        int currentDescription = localMap[(int)((localCount + 31L) / 32L)];
                        long descriptionLong = 0L;
                        CommandUtils.dbgPrint(out, "Local map (%d slots mapped): local %d --> ", localCount, localCount - 1L);
                        long bitsRemaining = localCount % 32L;
                        if (bitsRemaining != 0L) {
                            descriptionLong = currentDescription << (int)(32L - bitsRemaining);
                            --currentDescription;
                        }
                        while (localCount != 0L) {
                            if (bitsRemaining == 0L) {
                                descriptionLong = currentDescription;
                                --currentDescription;
                                bitsRemaining = 32L;
                            }
                            CommandUtils.dbgPrint(out, "%d", (descriptionLong & 1L) != 0L ? 1 : 0);
                            descriptionLong <<= 1;
                            --bitsRemaining;
                            --localCount;
                        }
                        CommandUtils.dbgPrint(out, " <-- local 0\n");
                    }
                } else {
                    CommandUtils.dbgPrint(out, "No locals to map\n");
                }
            } else {
                CommandUtils.dbgPrint(out, "Not found\n");
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private J9ROMMethodPointer J9ROMCLASS_ROMMETHODS(J9ROMClassPointer base) throws CorruptDataException {
        return base.romMethods();
    }
}

