/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm28.j9.DataType;
import com.ibm.j9ddr.vm28.pointer.AbstractPointer;
import com.ibm.j9ddr.vm28.pointer.PointerPointer;
import com.ibm.j9ddr.vm28.pointer.U32Pointer;
import com.ibm.j9ddr.vm28.pointer.U64Pointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm28.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassRefPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMStringRefPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm28.structure.J9ConstantPool;
import com.ibm.j9ddr.vm28.structure.J9ROMConstantPoolItem;
import java.io.PrintStream;

public class VMConstantPoolCommand
extends Command {
    static final String nl = System.getProperty("line.separator");

    public VMConstantPoolCommand() {
        this.addCommand("vmconstantpool", "[j9javavmAddress]", "Dump the jclconstantpool entries starting at the top and continuing through the end");
    }

    private void printUsage(PrintStream out) {
        out.println("vmconstantpool [j9javavmAddress] - Dump the jclconstantpool entries starting at the top and continuing through the end");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer javaVM = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (args.length == 1) {
                long vmaddress = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
                if (vmaddress != javaVM.getAddress()) {
                    out.println(args[0] + " is not a valid j9javavm address. Run !findvm to find out the j9javavm address of the current context");
                    return;
                }
            } else if (args.length > 1) {
                this.printUsage(out);
            }
            J9ConstantPoolPointer jclConstantPool = J9ConstantPoolPointer.cast(javaVM.jclConstantPoolEA());
            J9ROMClassPointer romClass = jclConstantPool.ramClass().romClass();
            U32Pointer cpShapeDescription = romClass.cpShapeDescription();
            long cpDescription = cpShapeDescription.at(0L).longValue();
            int constPoolCount = romClass.romConstantPoolCount().intValue();
            PointerPointer cpEntry = PointerPointer.cast(J9ROMClassHelper.constantPool(romClass));
            long cpDescriptionIndex = 0L;
            for (int index = 0; index < constPoolCount; ++index) {
                if (0L == cpDescriptionIndex) {
                    cpDescription = cpShapeDescription.at(0L).longValue();
                    cpShapeDescription = cpShapeDescription.add(1L);
                    cpDescriptionIndex = J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
                }
                long shapeDesc = cpDescription & J9ConstantPool.J9_CP_DESCRIPTION_MASK;
                AbstractPointer ref = PointerPointer.NULL;
                if (shapeDesc == J9ConstantPool.J9CPTYPE_CLASS) {
                    ref = J9ROMClassRefPointer.cast(cpEntry);
                } else if (shapeDesc == J9ConstantPool.J9CPTYPE_STRING) {
                    ref = J9ROMStringRefPointer.cast(cpEntry);
                } else if (shapeDesc == J9ConstantPool.J9CPTYPE_INT || shapeDesc == J9ConstantPool.J9CPTYPE_FLOAT) {
                    ref = J9ROMConstantPoolItemPointer.cast(cpEntry);
                } else if (shapeDesc == J9ConstantPool.J9CPTYPE_LONG) {
                    U64Pointer longPointer = U64Pointer.cast(cpEntry);
                    out.println("Long at " + longPointer.getHexAddress() + " {\n\t0x0: U64:" + longPointer.getHexValue() + "\n}");
                } else if (shapeDesc == J9ConstantPool.J9CPTYPE_DOUBLE) {
                    U64Pointer longPointer = U64Pointer.cast(cpEntry);
                    out.println("Double at " + longPointer.getHexAddress() + " {\n\t0x0: U64:" + longPointer.at(0L).longValue() + "\n}");
                } else if (shapeDesc == J9ConstantPool.J9CPTYPE_INSTANCE_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_STATIC_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_INTERFACE_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_HANDLE_METHOD || !J9BuildFlags.interp_useSplitSideTables && shapeDesc == J9ConstantPool.J9CPTYPE_SHARED_METHOD || shapeDesc == J9ConstantPool.J9CPTYPE_FIELD) {
                    long classRefCPIndex;
                    if (shapeDesc == J9ConstantPool.J9CPTYPE_FIELD) {
                        ref = J9ROMFieldRefPointer.cast(cpEntry);
                        classRefCPIndex = J9ROMFieldRefPointer.cast(ref).classRefCPIndex().longValue();
                    } else {
                        ref = J9ROMFieldRefPointer.cast(cpEntry);
                        classRefCPIndex = J9ROMMethodRefPointer.cast(ref).classRefCPIndex().longValue();
                    }
                    PointerPointer classRefCPEntry = PointerPointer.cast(J9ROMClassHelper.constantPool(romClass)).addOffset(J9ROMConstantPoolItem.SIZEOF * classRefCPIndex);
                    String outString = ref.formatFullInteractive();
                    String[] parts = outString.split(nl);
                    parts[1] = parts[1] + "(!j9romclassref " + classRefCPEntry.getHexAddress() + ")";
                    out.print(VMConstantPoolCommand.join(nl, parts));
                } else if (shapeDesc == J9ConstantPool.J9CPTYPE_UNUSED || shapeDesc == J9ConstantPool.J9CPTYPE_UNUSED8) {
                    U64Pointer longPointer = U64Pointer.cast(cpEntry);
                    out.println("Unused at " + longPointer.getHexAddress() + " {\n\t0x0: U64:" + longPointer.at(0L).longValue() + "\n}");
                } else if (ref.notNull()) {
                    out.println(ref.formatFullInteractive());
                }
                cpEntry = cpEntry.addOffset(J9ROMConstantPoolItem.SIZEOF);
                cpDescription >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
                --cpDescriptionIndex;
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private static String join(String separator, String[] strings) {
        StringBuffer sb = new StringBuffer();
        for (String string : strings) {
            sb.append(string).append(separator);
        }
        return sb.toString();
    }
}

