/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadTracker {
    private final Set<ThreadRef> threads = ConcurrentHashMap.newKeySet();

    public Object tryBegin() {
        ThreadRef threadRef = new ThreadRef(Thread.currentThread());
        return this.threads.add(threadRef) ? threadRef : null;
    }

    public Object begin() {
        ThreadRef threadRef = new ThreadRef(Thread.currentThread());
        boolean added = this.threads.add(threadRef);
        assert (added);
        return threadRef;
    }

    public void end(Object key) {
        ThreadRef threadRef = (ThreadRef)key;
        assert (threadRef.thread() == Thread.currentThread());
        boolean removed = this.threads.remove(threadRef);
        assert (removed);
    }

    public boolean contains(Thread thread) {
        ThreadRef threadRef = new ThreadRef(thread);
        return this.threads.contains(threadRef);
    }

    private final class ThreadRef {
        private final Thread thread;

        public ThreadRef(Thread thread) {
            this.thread = thread;
        }

        public Thread thread() {
            return this.thread;
        }

        public int hashCode() {
            return Long.hashCode(this.thread.getId());
        }

        public boolean equals(Object obj) {
            return obj instanceof ThreadRef ? ((ThreadRef)obj).thread == this.thread : false;
        }

        public String toString() {
            String threadToStringRes = this.thread != null ? this.thread.toString() : null;
            return "ThreadRef [" + threadToStringRes + "]";
        }
    }
}

