/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.io.ConsoleInputStream;
import com.ibm.jvm.io.ConsolePrintStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.security.action.GetPropertyAction;

final class UNIXProcess
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final int pid;
    private int exitcode;
    private boolean hasExited;
    private byte[] directory = null;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private static final LaunchMechanism launchMechanism = AccessController.doPrivileged(new PrivilegedAction<LaunchMechanism>(){

        @Override
        public LaunchMechanism run() {
            String string = System.getProperty("java.home");
            String string2 = System.getProperty("os.arch");
            UNIXProcess.access$002(UNIXProcess.toCString(string + "/lib/" + string2 + "/jspawnhelper"));
            String string3 = System.getProperty("jdk.lang.Process.launchMechanism", "posix_spawn");
            try {
                return LaunchMechanism.valueOf(string3.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Error(string3 + " is not a supported process launch mechanism on this platform.");
            }
        }
    });
    private static byte[] helperpath;
    static String platformEncoding;
    private static final Executor processReaperExecutor;

    private static byte[] toCString(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray2.length - 1] = 0;
        return byArray2;
    }

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(int var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9, boolean var10) throws IOException;

    private native int statExecutable(byte[] var1);

    UNIXProcess(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, byte[] byArray4, final int[] nArray, boolean bl) throws IOException {
        this.directory = byArray4;
        byte[] byArray5 = this.fullPath(byArray);
        this.pid = this.forkAndExec(0, null, byArray5, byArray2, n, byArray3, n2, byArray4, nArray, bl);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    UNIXProcess.this.initStreams(nArray);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    static FileDescriptor newFileDescriptor(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, n);
        return fileDescriptor;
    }

    void initStreams(int[] nArray) throws IOException {
        this.stdin = nArray[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new BufferedOutputStream(new FileOutputStream(UNIXProcess.newFileDescriptor(nArray[0])));
        this.stdout = nArray[1] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new BufferedInputStream(new DeferredCloseInputStream(UNIXProcess.newFileDescriptor(nArray[1])));
        this.stderr = nArray[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseInputStream(UNIXProcess.newFileDescriptor(nArray[2]));
        processReaperExecutor.execute(new Runnable(){

            @Override
            public void run() {
                int n = UNIXProcess.this.waitForProcessExit(UNIXProcess.this.pid);
                UNIXProcess.this.processExited(n);
            }
        });
    }

    synchronized void processExited(int n) {
        this.exitcode = n;
        this.hasExited = true;
        this.notifyAll();
    }

    @Override
    public OutputStream getOutputStream() {
        return ConsolePrintStream.localize(this.stdin);
    }

    @Override
    public InputStream getInputStream() {
        return ConsoleInputStream.localize(this.stdout);
    }

    @Override
    public InputStream getErrorStream() {
        return ConsoleInputStream.localize(this.stderr);
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            if (!this.hasExited) {
                UNIXProcess.destroyProcess(this.pid);
            }
        }
        try {
            this.stdin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stdout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stderr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] fullPath(byte[] byArray) throws IOException {
        String string;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("file.separator"));
        String string3 = ProcessEnvironment.getenv("PATH");
        String string4 = AccessController.doPrivileged(new GetPropertyAction("path.separator"));
        String string5 = null;
        byte[] byArray2 = null;
        try {
            string = new String(byArray, platformEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        if (string.indexOf(string2) < 0 && string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string4);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                string5 = stringTokenizer.nextToken() + string2 + string;
                try {
                    byArray2 = string5.getBytes(platformEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray2 = string5.getBytes();
                }
                if (this.statExecutable(byArray2) != 0) continue;
                bl = true;
            }
            if (!bl) {
                throw new IOException(string + ": not found");
            }
        } else {
            if (this.directory != null && string.indexOf(string2) > 0) {
                String string6;
                try {
                    string6 = new String(this.directory, 0, this.directory.length - 1, platformEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string6 = new String(this.directory, 0, this.directory.length - 1);
                }
                string5 = string6 + string2 + string;
                try {
                    byArray2 = string5.getBytes(platformEncoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray2 = string5.getBytes();
                }
            } else {
                byArray2 = byArray;
            }
            int n = this.statExecutable(byArray2);
            switch (n) {
                case -1: {
                    throw new IOException(string + ": not found");
                }
                case -2: {
                    throw new IOException(string + ": cannot execute");
                }
            }
        }
        return byArray2;
    }

    private static native void init();

    static /* synthetic */ byte[] access$002(byte[] byArray) {
        helperpath = byArray;
        return byArray;
    }

    static {
        processReaperExecutor = AccessController.doPrivileged(new PrivilegedAction<Executor>(){

            @Override
            public Executor run() {
                return Executors.newCachedThreadPool(new ProcessReaperThreadFactory());
            }
        });
        platformEncoding = AccessController.doPrivileged(new GetPropertyAction("ibm.system.encoding"));
        if (platformEncoding == null) {
            platformEncoding = AccessController.doPrivileged(new GetPropertyAction("console.encoding"));
        }
        if (platformEncoding == null) {
            platformEncoding = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        }
        UNIXProcess.init();
    }

    private static class DeferredCloseInputStream
    extends FileInputStream {
        private Object lock = new InterruptLock();
        private boolean closePending = false;
        private int useCount = 0;
        private InputStream streamToClose;

        private DeferredCloseInputStream(FileDescriptor fileDescriptor) {
            super(fileDescriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object = this.lock;
            synchronized (object) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.streamToClose.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeDeferred(InputStream inputStream) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.useCount == 0) {
                    inputStream.close();
                } else {
                    this.closePending = true;
                    this.streamToClose = inputStream;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.useCount = 0;
                this.closePending = false;
            }
            super.close();
        }

        @Override
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            this.raise();
            try {
                int n = super.read(byArray);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.raise();
            try {
                int n3 = super.read(byArray, n, n2);
                return n3;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            this.raise();
            try {
                long l2 = super.skip(l);
                return l2;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }

        private class InterruptLock {
            private InterruptLock() {
            }
        }
    }

    private static class ProcessReaperThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup group = ProcessReaperThreadFactory.getRootThreadGroup();
        private static final String reaperName = "process reaper";

        private ProcessReaperThreadFactory() {
        }

        private static ThreadGroup getRootThreadGroup() {
            return AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup.getParent() != null) {
                        threadGroup = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(group, runnable, reaperName, 32768L);
            thread.setDaemon(true);
            thread.setPriority(10);
            return thread;
        }
    }

    private static enum LaunchMechanism {
        POSIX_SPAWN(2);

        private int value;

        private LaunchMechanism(int n2) {
            this.value = n2;
        }
    }
}

