/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth.module;

import com.ibm.os390.security.PlatformThread;
import com.ibm.os390.security.PlatformUser;
import com.ibm.security.auth.UsernamePrincipal;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class JAASLoginModule
implements LoginModule {
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private UsernamePrincipal usernamePrincipal = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        try {
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.options = map2;
            this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean login() throws LoginException {
        char[] cArray;
        Object object;
        this.succeeded = false;
        if (this.callbackHandler == null) {
            this.usernamePrincipal = new UsernamePrincipal(PlatformThread.getUserName());
            this.succeeded = true;
            return this.succeeded;
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("OS/390 user id:"), new PasswordCallback("OS/390 password:", false)};
        try {
            this.callbackHandler.handle(callbackArray);
            this.usernamePrincipal = new UsernamePrincipal(((NameCallback)callbackArray[0]).getName());
            object = ((PasswordCallback)callbackArray[1]).getPassword();
            cArray = new char[((char[])object).length];
            System.arraycopy(object, 0, cArray, 0, ((char[])object).length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Callback Not Available.");
        }
        object = PlatformUser.authenticate((String)this.usernamePrincipal.getName(), (String)new String(cArray));
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
        if (object != null) {
            if (this.debug) {
                System.out.println("\t\t[JAASLoginModule] authentication with RACF failed.");
                System.out.println("\t\tContents of PlatformReturned object:");
                System.out.println("      success = " + object.success);
                System.out.println("      errno = " + object.errno);
                System.out.println("      errno2 = " + object.errno2);
                System.out.println("      errnoMsg = " + object.errnoMsg);
            }
            throw new FailedLoginException("Incorrect user password");
        }
        if (this.debug) {
            System.out.println("\t\t[JAASLoginModule] authentication with RACF succeeded");
            System.out.println("\t\t\tuserID = " + this.usernamePrincipal.getName());
        }
        this.succeeded = true;
        return this.succeeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            if (this.debug) {
                System.out.println("\t\t[JAASLoginModule]: did not add any Principal(s) or Credential(s) to the Subject because its own authentication failed.");
            }
            this.usernamePrincipal = null;
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.usernamePrincipal)) {
            this.subject.getPrincipals().add(this.usernamePrincipal);
        }
        if (this.debug) {
            System.out.println("\t\t[JAASLoginModule] added OS390Principal and OS390PasswordCredential to Subject");
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.out.println("\t\t[JAASLoginModule]: aborted authentication attempt");
        }
        if (this.succeeded && this.commitSucceeded) {
            this.logout();
        } else {
            this.usernamePrincipal = null;
            if (!this.succeeded) {
                return false;
            }
            this.succeeded = false;
        }
        return this.succeeded;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.usernamePrincipal != null && this.subject.getPrincipals().contains(this.usernamePrincipal)) {
            this.subject.getPrincipals().remove(this.usernamePrincipal);
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.usernamePrincipal = null;
        if (this.debug) {
            System.out.println("\t\t[JAASLoginModule] completed logout processing");
        }
        return true;
    }
}

