/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth;

import com.ibm.security.auth.OS390UserPrincipal;
import com.ibm.security.auth.UsernamePrincipal;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public abstract class ThreadSubject {
    static boolean alreadyLoaded;

    private native Object doAsThreadSubject(Subject var1, String var2, PrivilegedAction var3);

    private native Object doAsThreadSubject(Subject var1, String var2, PrivilegedExceptionAction var3) throws PrivilegedActionException;

    private native Object doAsThreadSubjectPrivileged(Subject var1, String var2, PrivilegedAction var3, AccessControlContext var4);

    private native Object doAsThreadSubjectPrivileged(Subject var1, String var2, PrivilegedExceptionAction var3, AccessControlContext var4) throws PrivilegedActionException;

    private static native void whoaminow0();

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        return ThreadSubject.privateDoAs(subject, privilegedAction, null, false);
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return ThreadSubject.privateDoAs(subject, privilegedExceptionAction, null, false);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        return ThreadSubject.privateDoAs(subject, privilegedAction, accessControlContext, true);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        return ThreadSubject.privateDoAs(subject, privilegedExceptionAction, accessControlContext, true);
    }

    static ThreadSubject getThreadSubject() {
        String string = null;
        ClassLoader classLoader = null;
        ThreadSubject threadSubject = null;
        string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("thread.subject.provider");
            }
        });
        if (string == null) {
            string = "com.ibm.security.auth.OS390ThreadSubject";
        }
        classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
        try {
            threadSubject = (ThreadSubject)Class.forName(string, true, classLoader).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return threadSubject;
    }

    private static Object privateDoAs(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext, boolean bl) {
        ThreadSubject threadSubject = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                securityManager.checkPermission(new AuthPermission("threadSubjectDoAsPrivileged"));
            } else {
                securityManager.checkPermission(new AuthPermission("threadSubjectDoAs"));
            }
        }
        if (privilegedAction == null) {
            throw new NullPointerException("Invalid null action.");
        }
        threadSubject = ThreadSubject.getThreadSubject();
        if (threadSubject != null) {
            String string;
            if (!alreadyLoaded) {
                ThreadSubject.ensureLoaded();
            }
            try {
                Set<Principal> set = subject.getPrincipals(UsernamePrincipal.class);
                if (set.isEmpty()) {
                    set = subject.getPrincipals(OS390UserPrincipal.class);
                    if (set.isEmpty()) {
                        throw new UnsupportedOperationException("No OS390 public principal exist for this subject.");
                    }
                    string = ((OS390UserPrincipal)set.iterator().next()).getName();
                } else {
                    string = set.iterator().next().getName();
                }
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            if (bl) {
                return threadSubject.doAsThreadSubjectPrivileged(subject, string, privilegedAction, accessControlContext);
            }
            return threadSubject.doAsThreadSubject(subject, string, privilegedAction);
        }
        throw new UnsupportedOperationException("No ThreadSubject implementation found.");
    }

    private static Object privateDoAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext, boolean bl) throws PrivilegedActionException {
        ThreadSubject threadSubject = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                securityManager.checkPermission(new AuthPermission("threadSubjectDoAsPrivileged"));
            } else {
                securityManager.checkPermission(new AuthPermission("threadSubjectDoAs"));
            }
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException("Invalid null action.");
        }
        threadSubject = ThreadSubject.getThreadSubject();
        if (threadSubject != null) {
            try {
                String string;
                Set<Principal> set = subject.getPrincipals(UsernamePrincipal.class);
                if (set.isEmpty()) {
                    set = subject.getPrincipals(OS390UserPrincipal.class);
                    if (set.isEmpty()) {
                        throw new UnsupportedOperationException("No OS390 public principal exist for this subject.");
                    }
                    string = ((OS390UserPrincipal)set.iterator().next()).getName();
                } else {
                    string = set.iterator().next().getName();
                }
                if (!alreadyLoaded) {
                    ThreadSubject.ensureLoaded();
                }
                ThreadSubject.ensureLoaded();
                if (bl) {
                    return threadSubject.doAsThreadSubjectPrivileged(subject, string, privilegedExceptionAction, accessControlContext);
                }
                return threadSubject.doAsThreadSubject(subject, string, privilegedExceptionAction);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new PrivilegedActionException(exception);
            }
        }
        throw new UnsupportedOperationException("No ThreadSubject implementation found.");
    }

    private static void ensureLoaded() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("ThreadSubject");
                return null;
            }
        });
        alreadyLoaded = true;
    }

    public static void whoaminow() {
        if (!alreadyLoaded) {
            ThreadSubject.ensureLoaded();
        }
        ThreadSubject.whoaminow0();
    }
}

