/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth;

import com.ibm.security.auth.SAFPermission;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

final class SAFPermissionCollection
extends PermissionCollection
implements Serializable {
    static final long serialVersionUID = -3135567070971044212L;
    private Hashtable permissions = new Hashtable(11);

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof SAFPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        SAFPermission sAFPermission = (SAFPermission)permission;
        this.permissions.put(sAFPermission.toString(), permission);
    }

    @Override
    public boolean implies(Permission permission) {
        Permission permission2;
        if (!(permission instanceof SAFPermission)) {
            return false;
        }
        SAFPermission sAFPermission = (SAFPermission)permission;
        Enumeration enumeration = this.permissions.keys();
        if (enumeration.hasMoreElements() && (permission2 = (Permission)this.permissions.get((String)enumeration.nextElement())) != null) {
            return permission2.implies(permission);
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

