/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.auth;

import com.ibm.os390.security.PlatformAccessControl;
import com.ibm.os390.security.PlatformReturned;
import com.ibm.security.auth.OS390UserPrincipal;
import com.ibm.security.auth.SAFPermissionCollection;
import com.ibm.security.auth.UsernamePrincipal;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;

public final class SAFPermission
extends Permission
implements Serializable {
    static final long serialVersionUID = -2160489397686898578L;
    private String securityClass;
    private Integer access;
    public static final Integer __READ_RESOURCE = new Integer(1);
    public static final Integer __UPDATE_RESOURCE = new Integer(2);
    public static final Integer __CONTROL_RESOURCE = new Integer(3);
    public static final Integer __ALTER_RESOURCE = new Integer(4);

    private void init(String string, String string2, Integer n) {
        if (string2 == null) {
            throw new NullPointerException("entityName can't be null");
        }
        if (string2.equals("")) {
            throw new IllegalArgumentException("entityName can't be empty");
        }
        if (string2.length() > 246) {
            throw new IllegalArgumentException("entityName must be shorter than 246 characters.");
        }
        if (n.compareTo(__READ_RESOURCE) < 0 || n.compareTo(__ALTER_RESOURCE) > 0) {
            throw new IllegalArgumentException("Access value is not valid");
        }
        if (string == null || string.equals("")) {
            string = new String("JAVA");
        } else if (string.length() > 8) {
            throw new IllegalArgumentException("securityClass must be shorter than 8 characters.");
        }
        this.securityClass = string;
        this.access = n;
    }

    public SAFPermission(String string, String string2, Integer n) {
        super(string2);
        this.init(string, string2, n);
    }

    public SAFPermission(String string, String string2) {
        super(string2);
        this.init(string, string2, __READ_RESOURCE);
    }

    public SAFPermission(String string, Integer n) {
        super(string);
        this.init("JAVA", string, n);
    }

    public SAFPermission(String string) {
        super(string);
        this.init("JAVA", string, __READ_RESOURCE);
    }

    @Override
    public boolean implies(Permission permission) {
        PlatformReturned platformReturned;
        Set<Principal> set;
        if (permission == null || permission.getClass() != this.getClass()) {
            return false;
        }
        try {
            set = Subject.getSubject(AccessController.getContext()).getPrincipals(UsernamePrincipal.class);
        }
        catch (NullPointerException nullPointerException) {
            throw new InternalError("Unable to find Username principal");
        }
        if (set.isEmpty()) {
            try {
                set = Subject.getSubject(AccessController.getContext()).getPrincipals(OS390UserPrincipal.class);
            }
            catch (NullPointerException nullPointerException) {
                throw new InternalError("Unable to find OS390 User principal");
            }
            if (set.isEmpty()) {
                throw new UnsupportedOperationException("No OS390 public user principal found.");
            }
            platformReturned = PlatformAccessControl.checkPermission((String)((OS390UserPrincipal)set.iterator().next()).getName(), (String)((SAFPermission)permission).securityClass, (String)permission.getName(), (int)((SAFPermission)permission).access);
        } else {
            platformReturned = PlatformAccessControl.checkPermission((String)set.iterator().next().getName(), (String)((SAFPermission)permission).securityClass, (String)permission.getName(), (int)((SAFPermission)permission).access);
        }
        return platformReturned == null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SAFPermission sAFPermission = (SAFPermission)object;
        return this.getName().equals(sAFPermission.getName()) && this.securityClass.equals(sAFPermission.getSecurityClass()) && this.access.equals(sAFPermission.getAccess());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String getActions() {
        return null;
    }

    public String getSecurityClass() {
        return this.securityClass;
    }

    public Integer getAccess() {
        return this.access;
    }

    @Override
    public String toString() {
        return "(" + this.securityClass + " " + this.getName() + " " + this.access.toString() + ")";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SAFPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getSecurityClass(), this.getName(), this.getAccess());
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

