/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.io;

import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class LocalizedOutputStream
extends FilterOutputStream {
    private CharsetEncoder ctb = Charset.defaultCharset().newEncoder();
    public static boolean nonASCIIPlatform = false;

    private LocalizedOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[1];
        char[] cArray = new char[]{(char)n};
        this.ctb.reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, 1);
        CoderResult coderResult = this.ctb.encode(charBuffer, byteBuffer, true);
        coderResult = this.ctb.flush(byteBuffer);
        this.out.write(byArray[0]);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        if ((n | n2 | byArray.length - n3 | n3) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = n; i < n3; ++i) {
            this.write(byArray[i]);
        }
    }

    public static OutputStream localize(OutputStream outputStream) {
        if (nonASCIIPlatform) {
            OutputStream outputStream2 = outputStream;
            while (outputStream2 != null && !(outputStream2 instanceof LocalizedOutputStream)) {
                Class<?> clazz;
                for (clazz = outputStream2.getClass(); clazz != null && clazz != FileOutputStream.class && clazz != FilterOutputStream.class; clazz = clazz.getSuperclass()) {
                }
                if (clazz == FilterOutputStream.class) {
                    outputStream2 = LocalizedOutputStream.unwrap((FilterOutputStream)outputStream2);
                    continue;
                }
                if (clazz != FileOutputStream.class) break;
                return new LocalizedOutputStream(outputStream);
            }
        }
        return outputStream;
    }

    public static OutputStream unwrap(FilterOutputStream filterOutputStream) {
        OutputStream outputStream;
        try {
            Class<?> clazz = filterOutputStream.getClass();
            Field field = clazz.getField("out");
            field.setAccessible(true);
            outputStream = (OutputStream)field.get(filterOutputStream);
        }
        catch (Exception exception) {
            outputStream = null;
        }
        return outputStream;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                nonASCIIPlatform = !System.getProperty("platform.notASCII", "false").equalsIgnoreCase("false");
                return null;
            }
        });
    }
}

