/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.BytecodeImageSection;
import com.ibm.dtfj.image.j9.JitImageSection;
import com.ibm.dtfj.java.JavaClass;
import java.util.Iterator;
import java.util.Vector;

public class JavaMethod
implements com.ibm.dtfj.java.JavaMethod {
    private ImagePointer _methodID;
    private String _methodName;
    private String _signature;
    private int _modifiers;
    private JavaClass _declaringClass;
    private Vector _compiledSections = new Vector();
    private Vector _bytecodeSections = new Vector();

    public JavaMethod(ImagePointer methodID, String name, String signature, int modifiers, JavaClass declaringClass) {
        if (null == methodID) {
            throw new IllegalArgumentException("A Java Method cannot have a null method ID");
        }
        if (null == declaringClass) {
            throw new IllegalArgumentException("A Java Method cannot have a null declaring class");
        }
        this._methodID = methodID;
        this._methodName = name;
        this._signature = signature;
        this._modifiers = modifiers;
        this._declaringClass = declaringClass;
    }

    @Override
    public Iterator getBytecodeSections() {
        return this._bytecodeSections.iterator();
    }

    @Override
    public Iterator getCompiledSections() {
        return this._compiledSections.iterator();
    }

    @Override
    public int getModifiers() throws CorruptDataException {
        return this._modifiers;
    }

    @Override
    public JavaClass getDeclaringClass() throws CorruptDataException, DataUnavailable {
        return this._declaringClass;
    }

    @Override
    public String getName() throws CorruptDataException {
        return this._methodName;
    }

    @Override
    public String getSignature() throws CorruptDataException {
        return this._signature;
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaMethod) {
            JavaMethod local = (JavaMethod)obj;
            isEqual = this._declaringClass.equals(local._declaringClass) && this._methodID.equals(local._methodID);
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        return this._declaringClass.hashCode() ^ this._methodID.hashCode();
    }

    public void createNewBytecodeSection(long start, long size) {
        BytecodeImageSection bytecodeSection = new BytecodeImageSection(this._methodID.getAddressSpace().getPointer(start), size);
        this._bytecodeSections.add(bytecodeSection);
    }

    public void createNewJITSection(long id, long start, long size) {
        JitImageSection jitSection = new JitImageSection(this._methodID.getAddressSpace().getPointer(id), this._methodID.getAddressSpace().getPointer(start), size);
        this._compiledSections.add(jitSection);
    }

    public String toString() {
        try {
            return this.getDeclaringClass().getName() + "." + this.getName() + this.getSignature();
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (DataUnavailable dataUnavailable) {
            // empty catch block
        }
        return super.toString();
    }
}

