/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.giop.GIOPUtil;
import com.ibm.rmi.io.IIOPInputStream;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.util.LinkedList;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import sun.misc.ObjectInputFilter;

final class FragmentQueue
extends LinkedList {
    private static final long serialVersionUID = 0L;
    private static final String CLASS = FragmentQueue.class.getName();
    private final int fragTimeout;
    final int requestId;
    final byte msgType;
    private boolean lastFragmentReceived = false;
    ObjectInputFilter filter = ObjectInputFilter.Config.getSerialFilter();
    private boolean abandoned;
    private int cumulativeMessageSize;

    public Object writeReplace() throws ObjectStreamException {
        throw new NotSerializableException(this.getClass().getName());
    }

    FragmentQueue(int n, byte by, int n2, int n3) {
        this.requestId = n;
        this.msgType = by;
        this.fragTimeout = n2;
        this.cumulativeMessageSize = n3;
    }

    synchronized void addNextFragment(WsByteBuffer[] wsByteBufferArray, int n) throws Exception {
        ObjectInputFilter.Status status;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "Next fragment for ", GIOPUtil.messageTypeName(this.msgType), " message, request number ", Trc.str(this.requestId), Trc.hex(wsByteBufferArray), CLASS, "addNextFragment:110");
        }
        if (this.abandoned) {
            return;
        }
        this.cumulativeMessageSize += n;
        if (this.filter != null && (status = this.filter.checkInput((ObjectInputFilter.FilterInfo)new IIOPInputStream.FilterValues(null, -1L, 0L, 0L, this.cumulativeMessageSize))) == ObjectInputFilter.Status.REJECTED) {
            this.abandoned = true;
            this.notify();
            throw new MARSHAL("filter status: REJECTED", 1229125809, CompletionStatus.COMPLETED_NO);
        }
        this.add(wsByteBufferArray);
        this.notify();
    }

    synchronized void addLastFragment(WsByteBuffer[] wsByteBufferArray, int n) throws Exception {
        this.lastFragmentReceived = true;
        this.addNextFragment(wsByteBufferArray, n);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "Last fragment received.", CLASS, "addLastFragment:136");
        }
    }

    synchronized WsByteBuffer[] getNextFragment() {
        if (this.size() > 0) {
            return (WsByteBuffer[])this.removeFirst();
        }
        if (this.fragTimeout == 0) {
            do {
                try {
                    this.wait();
                    if (this.abandoned) {
                        throw new MARSHAL("filter status: REJECTED", 1229125809, CompletionStatus.COMPLETED_NO);
                    }
                    if (this.size() > 0) {
                        return (WsByteBuffer[])this.removeFirst();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.size() <= 0);
            return (WsByteBuffer[])this.removeFirst();
        }
        long l = this.fragTimeout;
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                this.wait(l);
                if (this.abandoned) {
                    throw new MARSHAL("filter status: REJECTED", 1229125809, CompletionStatus.COMPLETED_NO);
                }
                if (this.size() > 0) {
                    return (WsByteBuffer[])this.removeFirst();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.size() > 0) {
                return (WsByteBuffer[])this.removeFirst();
            }
            l = l2 - System.currentTimeMillis();
        }
        throw GIOPUtil.fragmentTimeoutException(this.requestId, this.msgType);
    }

    synchronized boolean finished() {
        return this.lastFragmentReceived && this.isEmpty();
    }
}

