/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.wlm;

import com.ibm.jzos.ErrnoException;
import com.ibm.jzos.JzosPermission;
import com.ibm.jzos.ZUtil;
import com.ibm.jzos.wlm.ServerClassification;

public class WorkUnit {
    private long enclaveToken;

    public WorkUnit() throws ErrnoException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JzosPermission("WorkloadManager"));
        }
        this.enclaveToken = this.continueWorkUnit();
    }

    public WorkUnit(ServerClassification serverClassification, String functionName) {
        this(serverClassification, ZUtil.getTodClock(), functionName);
    }

    public WorkUnit(ServerClassification serverClassification, byte[] arrivalTime, String functionName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JzosPermission("WorkloadManager"));
        }
        this.enclaveToken = this.createWorkUnit(serverClassification.hCda, arrivalTime, functionName);
    }

    public void run(Runnable runnable) throws ErrnoException {
        this.join();
        try {
            runnable.run();
        }
        finally {
            this.leave();
        }
    }

    public Runnable wrap(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                WorkUnit.this.run(runnable);
            }
        };
    }

    public void join() throws ErrnoException {
        this.checkNotDeleted();
        this.joinWorkUnit(this.enclaveToken);
    }

    public void leave() throws ErrnoException {
        this.checkNotDeleted();
        this.leaveWorkUnit(this.enclaveToken);
    }

    public void delete() throws ErrnoException {
        if (!this.isDeleted()) {
            this.deleteWorkUnit(this.enclaveToken);
            this.enclaveToken = 0L;
        }
    }

    public boolean isDeleted() {
        return this.enclaveToken == 0L;
    }

    public long getEnclaveToken() {
        this.checkNotDeleted();
        return this.enclaveToken;
    }

    private void checkNotDeleted() {
        if (this.isDeleted()) {
            throw new IllegalStateException("WorkUnit has been deleted");
        }
    }

    private native long continueWorkUnit() throws ErrnoException;

    private native void joinWorkUnit(long var1) throws ErrnoException;

    private native void leaveWorkUnit(long var1) throws ErrnoException;

    private native void deleteWorkUnit(long var1) throws ErrnoException;

    private native long createWorkUnit(long var1, byte[] var3, String var4) throws ErrnoException;

    static {
        ZUtil.touch();
    }
}

