/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.wlm;

import com.ibm.jzos.ByteUtil;

public class QueryVirtualServerResult {
    public static final int CEC_CAPACITY_STATUS_UNDEFINED = 0;
    public static final int CEC_CAPACITY_STATUS_NOMINAL = 1;
    public static final int CEC_CAPACITY_STATUS_REDMANUAL = 2;
    public static final int CEC_CAPACITY_STATUS_REDMACHEX = 3;
    public static final int CEC_CAPACITY_STATUS_REDMACHNOEX = 4;
    public static final int CEC_CAPACITY_STATUS_REDEXTCOND = 5;
    private static final int VERSION_OFFSET = 4;
    private static final int VERSION_LEN = 1;
    private static final int FLAGS_OFFSET = 5;
    private static final int FLAG_CEC_VALID_BIT = 7;
    private static final int FLAG_IMAGE_VALID_BIT = 6;
    private static final int FLAG_VM_VALID_BIT = 5;
    private static final int CEC_CAPACITY_STATUS_OFFSET = 7;
    private static final int CEC_CAPACITY_STATUS_LEN = 1;
    private static final int CEC_MACHINE_TYPE_OFFSET = 8;
    private static final int CEC_MACHINE_TYPE_LEN = 4;
    private static final int CEC_MODEL_ID_OFFSET = 12;
    private static final int CEC_MODEL_ID_LEN = 16;
    private static final int CEC_SEQUENCE_CODE_OFFSET = 28;
    private static final int CEC_SEQUENCE_CODE_LEN = 16;
    private static final int CEC_MANUFACTURER_NAME_OFFSET = 44;
    private static final int CEC_MANUFACTURER_NAME_LEN = 16;
    private static final int CEC_PLANT_OF_MANUFACTURE_OFFSET = 60;
    private static final int CEC_PLANT_OF_MANUFACTURE_LEN = 4;
    private static final int CEC_CAPACITY_OFFSET = 64;
    private static final int CEC_CAPACITY_LEN = 4;
    private static final int IMAGE_LPAR_NAME_OFFSET = 68;
    private static final int IMAGE_LPAR_NAME_LEN = 8;
    private static final int IMAGE_LPAR_ID_OFFSET = 76;
    private static final int IMAGE_LPAR_ID_LEN = 2;
    private static final int IMAGE_CAPACITY_OFFSET = 80;
    private static final int IMAGE_CAPACITY_LEN = 4;
    private static final int VM_NAME_OFFSET = 84;
    private static final int VM_NAME_LEN = 8;
    private static final int VM_CAPACITY_OFFSET = 92;
    private static final int VM_CAPACITY_LEN = 4;
    private byte[] qvsBytes = null;
    private boolean cecValid = false;
    private boolean imageValid = false;
    private boolean vmValid = false;

    QueryVirtualServerResult(byte[] qvsBytes) {
        this.qvsBytes = qvsBytes;
        byte flags = qvsBytes[5];
        this.cecValid = (flags & 0x80) != 0;
        this.imageValid = (flags & 0x40) != 0;
        this.vmValid = (flags & 0x20) != 0;
    }

    public int getVersion() {
        return ByteUtil.bytesAsInt(this.qvsBytes, 4, 1);
    }

    public boolean isCecValid() {
        return this.cecValid;
    }

    public boolean isImageValid() {
        return this.imageValid;
    }

    public boolean isVmValid() {
        return this.vmValid;
    }

    public int getCecCapacityStatus() {
        return this.cecValid ? ByteUtil.bytesAsInt(this.qvsBytes, 7, 1) : -1;
    }

    public String getCecMachineType() {
        return this.cecValid ? ByteUtil.bytesAsString(this.qvsBytes, 8, 4, "IBM-1047") : null;
    }

    public String getCecModelId() {
        return this.cecValid ? ByteUtil.bytesAsString(this.qvsBytes, 12, 16, "IBM-1047") : null;
    }

    public String getCecSequenceCode() {
        return this.cecValid ? ByteUtil.bytesAsString(this.qvsBytes, 28, 16, "IBM-1047") : null;
    }

    public String getCecManufacturerName() {
        return this.cecValid ? ByteUtil.bytesAsString(this.qvsBytes, 44, 16, "IBM-1047") : null;
    }

    public String getCecPlantOfManufacture() {
        return this.cecValid ? ByteUtil.bytesAsString(this.qvsBytes, 60, 4, "IBM-1047") : null;
    }

    public long getCecCapacity() {
        return this.cecValid ? ByteUtil.bytesAsLong(this.qvsBytes, 64, 4) : -1L;
    }

    public String getImageLparName() {
        return this.imageValid ? ByteUtil.bytesAsString(this.qvsBytes, 68, 8, "IBM-1047") : null;
    }

    public int getImageLparId() {
        return this.imageValid ? ByteUtil.bytesAsInt(this.qvsBytes, 76, 2) : -1;
    }

    public long getImageCapacity() {
        return this.imageValid ? ByteUtil.bytesAsLong(this.qvsBytes, 80, 4) : -1L;
    }

    public String getVmName() {
        return this.vmValid ? ByteUtil.bytesAsString(this.qvsBytes, 84, 8, "IBM-1047") : null;
    }

    public long getVmCapacity() {
        return this.vmValid ? ByteUtil.bytesAsLong(this.qvsBytes, 92, 4) : -1L;
    }
}

