/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.wlm;

import com.ibm.jzos.RcException;
import com.ibm.jzos.ZUtil;
import com.ibm.jzos.wlm.QueryContentionResult;

public class QueryContention {
    public static final int REQTYPE_ALL = 0;
    public static final int REQTYPE_ENQHOLDS = 1;
    public static final int REQTYPE_CHRONIC_CONTENTIONS = 2;
    private static boolean isQRYCONTSupported = true;
    private static byte[] asidDefault = new byte[]{-1, -1};

    QueryContention() {
    }

    public static QueryContentionResult query() throws RcException, UnsupportedOperationException {
        return QueryContention.query(0, asidDefault);
    }

    public static QueryContentionResult query(int requestType) throws RcException, UnsupportedOperationException {
        return QueryContention.query(requestType, asidDefault);
    }

    public static QueryContentionResult query(byte[] asid) throws RcException, UnsupportedOperationException {
        return QueryContention.query(0, asid);
    }

    public static QueryContentionResult query(int requestType, byte[] asid) throws RcException, UnsupportedOperationException {
        if (!isQRYCONTSupported) {
            throw new UnsupportedOperationException("SYSEVENT QRYCONT is not supported by a z/OS release earlier than V2R1.");
        }
        if (requestType != 0 && requestType != 1 && requestType != 2) {
            throw new IllegalArgumentException("Invalid requestType " + requestType);
        }
        if (asid.length != 2) {
            throw new IllegalArgumentException("Invalid asid. Two-bytes in hex values are expected.");
        }
        QueryContentionResult result = null;
        try {
            result = QueryContention.queryContention(requestType, asid);
        }
        catch (UnsupportedOperationException uex) {
            isQRYCONTSupported = false;
            throw new UnsupportedOperationException("SYSEVENT QRYCONT is not supported by a z/OS release earlier than V2R1.");
        }
        catch (RcException rex) {
            throw rex;
        }
        return result;
    }

    private static native QueryContentionResult queryContention(int var0, byte[] var1) throws RcException, UnsupportedOperationException;

    static {
        ZUtil.touch();
    }
}

