/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.jzos.fields.ExternalDecimalAsIntField;

public class ZonedUnsignedIntField
extends ExternalDecimalAsIntField {
    protected static final boolean EXCEPTIONS = false;

    public ZonedUnsignedIntField(int offset, int precision) {
        super(offset, precision, false, false, false, false);
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) {
        int value = DecimalData.convertExternalDecimalToInteger((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision(), (boolean)false, (int)1);
        if (value < 0) {
            throw new IllegalArgumentException("" + value);
        }
        return value;
    }

    @Override
    public int getInt(byte[] buffer) {
        int value = DecimalData.convertExternalDecimalToInteger((byte[])buffer, (int)this.getOffset(), (int)this.getPrecision(), (boolean)false, (int)1);
        if (value < 0) {
            throw new IllegalArgumentException("" + value);
        }
        return value;
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToExternalDecimal((int)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision(), (boolean)false, (int)1);
        int n = this.getOffset() + bufOffset + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF0);
    }

    @Override
    public void putInt(int value, byte[] buffer) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToExternalDecimal((int)value, (byte[])buffer, (int)this.getOffset(), (int)this.getPrecision(), (boolean)false, (int)1);
        int n = this.getOffset() + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF0);
    }

    @Override
    protected void rangeCheck(int value) {
        if (value < 0 || value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
    }
}

