/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.daa.PackedUnsignedLongField;

public class PackedUnsignedLongP16Field
extends PackedUnsignedLongField {
    private static final int PRECISION = 16;

    public PackedUnsignedLongP16Field(int offset) {
        super(offset, 16);
    }

    @Override
    public long getLong(byte[] buffer, int bufOffset) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)16);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        long value = DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)16, (boolean)false);
        this.rangeCheck(value);
        return value;
    }

    @Override
    public long getLong(byte[] buffer) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)16);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        long value = DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)this.getOffset(), (int)16, (boolean)false);
        if (value < 0L) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return value;
    }

    @Override
    public void putLong(long value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)16, (boolean)false);
        int n = this.getOffset() + bufOffset + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF);
    }

    @Override
    public void putLong(long value, byte[] buffer) throws IllegalArgumentException {
        if (value < 0L) {
            throw new IllegalArgumentException("" + value);
        }
        DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)this.getOffset(), (int)16, (boolean)false);
        int n = this.getOffset() + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF);
    }
}

