/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.daa.PackedUnsignedIntField;

public class PackedUnsignedIntP9Field
extends PackedUnsignedIntField {
    private static final int PRECISION = 9;

    public PackedUnsignedIntP9Field(int offset) {
        super(offset, 9);
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)9);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        int value = DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)9, (boolean)false);
        if (value < 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit. value=" + value);
        }
        return value;
    }

    @Override
    public int getInt(byte[] buffer) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)9);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        int value = DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)this.getOffset(), (int)9, (boolean)false);
        if (value < 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit. value=" + value);
        }
        return value;
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToPackedDecimal((int)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)9, (boolean)false);
        int n = this.getOffset() + bufOffset + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF);
    }

    @Override
    public void putInt(int value, byte[] buffer) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToPackedDecimal((int)value, (byte[])buffer, (int)this.getOffset(), (int)9, (boolean)false);
        int n = this.getOffset() + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF);
    }
}

