/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.PackedDecimalAsIntField;

public class PackedUnsignedIntField
extends PackedDecimalAsIntField {
    protected static final boolean EXCEPTIONS = false;

    public PackedUnsignedIntField(int offset, int precision) {
        super(offset, precision, false);
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision());
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        int value = DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision(), (boolean)false);
        if (value < 0) {
            throw new IllegalArgumentException("" + value);
        }
        return value;
    }

    @Override
    public int getInt(byte[] buffer) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)this.getPrecision());
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        int value = DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)this.getOffset(), (int)this.getPrecision(), (boolean)false);
        if (value < 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit. value=" + value);
        }
        return value;
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToPackedDecimal((int)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)this.getPrecision(), (boolean)false);
        int n = this.getOffset() + bufOffset + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF);
    }

    @Override
    public void putInt(int value, byte[] buffer) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToPackedDecimal((int)value, (byte[])buffer, (int)this.getOffset(), (int)this.getPrecision(), (boolean)false);
        int n = this.getOffset() + this.getByteLength() - 1;
        buffer[n] = (byte)(buffer[n] | 0xF);
    }

    @Override
    protected void rangeCheck(int value) {
        if (value < 0 || value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
    }
}

