/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.daa.PackedSignedLongField;

public class PackedSignedLongP17Field
extends PackedSignedLongField {
    private static final int PRECISION = 17;

    public PackedSignedLongP17Field(int offset) {
        super(offset, 17);
    }

    @Override
    public long getLong(byte[] buffer, int bufOffset) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)17);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)17, (boolean)false);
    }

    @Override
    public long getLong(byte[] buffer) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)17);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)this.getOffset(), (int)17, (boolean)false);
    }

    @Override
    public void putLong(long value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)17, (boolean)false);
    }

    @Override
    public void putLong(long value, byte[] buffer) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)this.getOffset(), (int)17, (boolean)false);
    }
}

