/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.daa.PackedSignedLongField;

public class PackedSignedLongP14Field
extends PackedSignedLongField {
    private static final int PRECISION = 14;

    public PackedSignedLongP14Field(int offset) {
        super(offset, 14);
    }

    @Override
    public long getLong(byte[] buffer, int bufOffset) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)14);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)14, (boolean)false);
    }

    @Override
    public long getLong(byte[] buffer) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)14);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToLong((byte[])buffer, (int)this.getOffset(), (int)14, (boolean)false);
    }

    @Override
    public void putLong(long value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)14, (boolean)false);
    }

    @Override
    public void putLong(long value, byte[] buffer) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertLongToPackedDecimal((long)value, (byte[])buffer, (int)this.getOffset(), (int)14, (boolean)false);
    }
}

