/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.daa.PackedSignedIntField;

public class PackedSignedIntP5Field
extends PackedSignedIntField {
    private static final int PRECISION = 5;

    public PackedSignedIntP5Field(int offset) {
        super(offset, 5);
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)5);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)5, (boolean)false);
    }

    @Override
    public int getInt(byte[] buffer) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)5);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)this.getOffset(), (int)5, (boolean)false);
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToPackedDecimal((int)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)5, (boolean)false);
    }

    @Override
    public void putInt(int value, byte[] buffer) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToPackedDecimal((int)value, (byte[])buffer, (int)this.getOffset(), (int)5, (boolean)false);
    }
}

