/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.daa.PackedSignedIntField;

public class PackedSignedIntP3Field
extends PackedSignedIntField {
    private static final int PRECISION = 3;

    public PackedSignedIntP3Field(int offset) {
        super(offset, 3);
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)3);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)3, (boolean)false);
    }

    @Override
    public int getInt(byte[] buffer) {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)3);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToInteger((byte[])buffer, (int)this.getOffset(), (int)3, (boolean)false);
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToPackedDecimal((int)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)3, (boolean)false);
    }

    @Override
    public void putInt(int value, byte[] buffer) throws IllegalArgumentException {
        this.rangeCheck(value);
        DecimalData.convertIntegerToPackedDecimal((int)value, (byte[])buffer, (int)this.getOffset(), (int)3, (boolean)false);
    }
}

