/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.daa.PackedBigDecimalField;
import java.math.BigDecimal;

public class PackedBigDecimalP14Field
extends PackedBigDecimalField {
    private static final int PRECISION = 14;

    public PackedBigDecimalP14Field(int offset, int scale) {
        super(offset, 14, scale);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)14);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)14, (int)this.getScale(), (boolean)true);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] buffer) throws IllegalArgumentException {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)14);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal((byte[])buffer, (int)this.getOffset(), (int)14, (int)this.getScale(), (boolean)true);
    }

    @Override
    public void putBigDecimal(BigDecimal value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.getScale(), 1);
        if (bd.precision() > 14) {
            throw new IllegalArgumentException("" + value);
        }
        DecimalData.convertBigDecimalToPackedDecimal((BigDecimal)bd, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)14, (boolean)true);
    }

    @Override
    public void putBigDecimal(BigDecimal value, byte[] buffer) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.getScale(), 1);
        if (bd.precision() > 14) {
            throw new IllegalArgumentException("" + value);
        }
        DecimalData.convertBigDecimalToPackedDecimal((BigDecimal)bd, (byte[])buffer, (int)this.getOffset(), (int)14, (boolean)true);
    }
}

