/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.DecimalData;
import com.ibm.dataaccess.PackedDecimal;
import com.ibm.jzos.fields.daa.PackedBigDecimalField;
import java.math.BigDecimal;

public class PackedBigDecimalP13Field
extends PackedBigDecimalField {
    private static final int PRECISION = 13;

    public PackedBigDecimalP13Field(int offset, int scale) {
        super(offset, 13, scale);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)13);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal((byte[])buffer, (int)(this.getOffset() + bufOffset), (int)13, (int)this.getScale(), (boolean)true);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] buffer) throws IllegalArgumentException {
        int rc = PackedDecimal.checkPackedDecimal((byte[])buffer, (int)this.getOffset(), (int)13);
        if (rc != 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal((byte[])buffer, (int)this.getOffset(), (int)13, (int)this.getScale(), (boolean)true);
    }

    @Override
    public void putBigDecimal(BigDecimal value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.getScale(), 1);
        if (bd.precision() > 13) {
            throw new IllegalArgumentException("" + value);
        }
        DecimalData.convertBigDecimalToPackedDecimal((BigDecimal)bd, (byte[])buffer, (int)(this.getOffset() + bufOffset), (int)13, (boolean)true);
    }

    @Override
    public void putBigDecimal(BigDecimal value, byte[] buffer) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.getScale(), 1);
        if (bd.precision() > 13) {
            throw new IllegalArgumentException("" + value);
        }
        DecimalData.convertBigDecimalToPackedDecimal((BigDecimal)bd, (byte[])buffer, (int)this.getOffset(), (int)13, (boolean)true);
    }
}

