/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.ByteArrayMarshaller;
import com.ibm.dataaccess.ByteArrayUnmarshaller;
import com.ibm.jzos.fields.BinaryAsIntField;

public class BinaryUnsignedIntField
extends BinaryAsIntField {
    protected static final boolean BIG_ENDIAN = true;
    protected static final boolean SIGN_EXTEND = false;
    protected final int maxValue;

    public BinaryUnsignedIntField(int offset) {
        super(offset, 4, false);
        this.maxValue = this.initMaxValue(this.length);
    }

    public BinaryUnsignedIntField(int offset, int length) {
        super(offset, length, false);
        this.maxValue = this.initMaxValue(length);
    }

    private int initMaxValue(int length) {
        switch (length) {
            case 1: {
                return 255;
            }
            case 2: {
                return 65535;
            }
            case 3: {
                return 0xFFFFFF;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid field length: " + length);
    }

    @Override
    public void setSigned(boolean signed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(byte[] buffer) {
        int value = ByteArrayUnmarshaller.readInt((byte[])buffer, (int)this.getOffset(), (boolean)true, (int)this.length, (boolean)false);
        if (value < 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return value;
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) {
        int value = ByteArrayUnmarshaller.readInt((byte[])buffer, (int)(this.getOffset() + bufOffset), (boolean)true, (int)this.length, (boolean)false);
        if (value < 0) {
            throw new IllegalArgumentException("Packed field contains invalid sign or digit.");
        }
        return value;
    }

    @Override
    public void putInt(int value, byte[] buffer) {
        this.rangeCheck(value, 0, this.maxValue);
        ByteArrayMarshaller.writeInt((int)value, (byte[])buffer, (int)this.getOffset(), (boolean)true, (int)this.length);
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) {
        this.rangeCheck(value, 0, this.maxValue);
        ByteArrayMarshaller.writeInt((int)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (boolean)true, (int)this.length);
    }
}

