/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields.daa;

import com.ibm.dataaccess.ByteArrayMarshaller;
import com.ibm.dataaccess.ByteArrayUnmarshaller;
import com.ibm.jzos.fields.BinaryAsIntField;

public class BinarySignedIntField
extends BinaryAsIntField {
    protected static final boolean BIG_ENDIAN = true;
    protected static final boolean SIGN_EXTEND = true;
    protected final int minValue;
    protected final int maxValue;

    public BinarySignedIntField(int offset) {
        super(offset, 4, true);
        this.minValue = this.initMinValue(this.length);
        this.maxValue = this.initMaxValue(this.length);
    }

    public BinarySignedIntField(int offset, int length) {
        super(offset, length, true);
        this.minValue = this.initMinValue(length);
        this.maxValue = this.initMaxValue(length);
    }

    private int initMinValue(int length) {
        switch (length) {
            case 1: {
                return -128;
            }
            case 2: {
                return Short.MIN_VALUE;
            }
            case 3: {
                return -8388608;
            }
            case 4: {
                return Integer.MIN_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid field length: " + length);
    }

    private int initMaxValue(int length) {
        switch (length) {
            case 1: {
                return 127;
            }
            case 2: {
                return Short.MAX_VALUE;
            }
            case 3: {
                return 0x7FFFFF;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid field length: " + length);
    }

    @Override
    public void setSigned(boolean signed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(byte[] buffer) {
        return ByteArrayUnmarshaller.readInt((byte[])buffer, (int)this.getOffset(), (boolean)true, (int)this.length, (boolean)true);
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) {
        return ByteArrayUnmarshaller.readInt((byte[])buffer, (int)(this.getOffset() + bufOffset), (boolean)true, (int)this.length, (boolean)true);
    }

    @Override
    public void putInt(int value, byte[] buffer) {
        this.rangeCheck(value, this.minValue, this.maxValue);
        ByteArrayMarshaller.writeInt((int)value, (byte[])buffer, (int)this.getOffset(), (boolean)true, (int)this.length);
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) {
        this.rangeCheck(value, this.minValue, this.maxValue);
        ByteArrayMarshaller.writeInt((int)value, (byte[])buffer, (int)(this.getOffset() + bufOffset), (boolean)true, (int)this.length);
    }
}

