/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.IntAccessor;

public class PackedDecimalAsIntField
implements IntAccessor {
    private static final int MAX_PRECISION = 9;
    private static final int[] MAX_VALUES = new int[10];
    private static byte[] PACKED_BYTES;
    private int offset;
    private int length;
    private int precision;
    private boolean signed;
    protected final int maxValue;
    protected final int minValue;

    public PackedDecimalAsIntField(int offset, int precision, boolean signed) {
        if (precision < 1 || precision > 9) {
            throw new IllegalArgumentException("length");
        }
        this.offset = offset;
        this.precision = precision;
        this.length = (precision + 2) / 2;
        this.signed = signed;
        this.maxValue = MAX_VALUES[precision];
        this.minValue = -this.maxValue;
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getInt(byte[] buffer) throws IllegalArgumentException {
        return this.getInt(buffer, 0);
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int b;
        int i;
        int value = 0;
        int ilast = i + this.length - 1;
        for (i = this.offset + bufOffset; i < ilast; ++i) {
            b = buffer[i] & 0xFF;
            value = value * 10 + (b >>> 4);
            value = value * 10 + (b & 0xF);
        }
        b = buffer[ilast] & 0xFF;
        value = value * 10 + (b >>> 4);
        if (this.signed) {
            int sn = b & 0xF;
            if (sn < 10) {
                throw new IllegalArgumentException("Packed field contains invalid sign.");
            }
            if (sn == 11 || sn == 13) {
                value = 0 - value;
            }
        }
        return value;
    }

    @Override
    public void putInt(int value, byte[] buffer) throws IllegalArgumentException {
        this.putInt(value, buffer, 0);
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int signNibble;
        if (value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
        if (this.signed) {
            if (value < 0) {
                if (value < this.minValue) {
                    throw new IllegalArgumentException("" + value);
                }
                signNibble = 13;
                value = -value;
            } else {
                signNibble = 12;
            }
        } else {
            if (value < 0) {
                throw new IllegalArgumentException("" + value);
            }
            signNibble = 15;
        }
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        buffer[ilast] = (byte)(value % 10 << 4 | signNibble);
        value /= 10;
        for (int i = ilast - 1; i >= ifirst; --i) {
            buffer[i] = PACKED_BYTES[value % 100];
            value /= 100;
        }
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    public boolean equals(Integer anInteger, int anInt) {
        if (anInteger == null) {
            return false;
        }
        return anInteger == anInt;
    }

    protected void rangeCheck(int value) {
        if (value < this.minValue || value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
    }

    static {
        int itoten = 1;
        for (int i = 0; i < MAX_VALUES.length; ++i) {
            PackedDecimalAsIntField.MAX_VALUES[i] = itoten - 1;
            itoten *= 10;
        }
        PACKED_BYTES = new byte[100];
        for (int i = 0; i < 100; ++i) {
            int low = i % 10;
            int high = i / 10 % 10;
            PackedDecimalAsIntField.PACKED_BYTES[i] = (byte)((high << 4) + low);
        }
    }
}

