/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BigDecimalAccessor;
import com.ibm.jzos.fields.PackedDecimalAsBigIntegerField;
import java.math.BigDecimal;

public class PackedDecimalAsBigDecimalField
implements BigDecimalAccessor {
    private PackedDecimalAsBigIntegerField biConverter;
    private int scale;

    public PackedDecimalAsBigDecimalField(int offset, int precision, int scale, boolean signed) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale must be >= 0");
        }
        this.biConverter = new PackedDecimalAsBigIntegerField(offset, precision, 0, signed);
        this.scale = scale;
    }

    @Override
    public int getByteLength() {
        return this.biConverter.getByteLength();
    }

    @Override
    public int getOffset() {
        return this.biConverter.getOffset();
    }

    @Override
    public void setOffset(int offset) {
        this.biConverter.setOffset(offset);
    }

    public int getPrecision() {
        return this.biConverter.getPrecision();
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isSigned() {
        return this.biConverter.isSigned();
    }

    @Override
    public BigDecimal getBigDecimal(byte[] buffer) throws IllegalArgumentException {
        return this.getBigDecimal(buffer, 0);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] buffer, int bufOffset) throws IllegalArgumentException {
        return new BigDecimal(this.biConverter.getBigInteger(buffer, bufOffset), this.scale);
    }

    @Override
    public void putBigDecimal(BigDecimal value, byte[] buffer) throws IllegalArgumentException {
        this.putBigDecimal(value, buffer, 0);
    }

    @Override
    public void putBigDecimal(BigDecimal value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        BigDecimal bd = value.setScale(this.scale, 1);
        this.biConverter.putBigInteger(bd.unscaledValue(), buffer, bufOffset);
    }

    public boolean equals(BigDecimal a, BigDecimal b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }
}

