/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.LongAccessor;

public class ExternalDecimalAsLongField
implements LongAccessor {
    private int offset;
    private int length;
    private int precision;
    private boolean signed;
    private boolean signTrailing;
    private boolean signExternal;
    private boolean blankWhenZero;
    protected final long minValue;
    protected final long maxValue;
    private static final byte EBCDIC_MINUS = 96;
    private static final byte EBCDIC_PLUS = 78;
    private static final byte EBCDIC_SPACE = 64;
    private static final int MAX_PRECISION = 18;
    private static final long[] MAX_VALUES = new long[19];

    public ExternalDecimalAsLongField(int offset, int precision, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        if (precision < 1 || precision > 18) {
            throw new IllegalArgumentException("precision=" + precision);
        }
        this.offset = offset;
        this.precision = precision;
        this.signed = signed;
        this.signTrailing = signed && signTrailing;
        this.signExternal = signed && signExternal;
        this.blankWhenZero = blankWhenZero;
        this.length = precision + (this.signExternal ? 1 : 0);
        this.maxValue = MAX_VALUES[precision];
        this.minValue = -this.maxValue;
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public long getLong(byte[] buffer) {
        return this.getLong(buffer, 0);
    }

    @Override
    public long getLong(byte[] buffer, int bufOffset) {
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        if (this.blankWhenZero && this.isAllBlanks(buffer, ifirst, ilast)) {
            return 0L;
        }
        boolean effectiveSign = true;
        if (this.signed) {
            if (this.signExternal) {
                effectiveSign = this.signTrailing ? buffer[ilast--] != 96 : buffer[ifirst++] != 96;
            } else {
                int signHighNibble = buffer[this.signTrailing ? ilast : ifirst] & 0xF0;
                effectiveSign = signHighNibble != 208 && signHighNibble != 176;
            }
        }
        long value = 0L;
        for (int i = ifirst; i <= ilast; ++i) {
            value = value * 10L + (long)(buffer[i] & 0xF);
        }
        return effectiveSign ? value : -value;
    }

    private boolean isAllBlanks(byte[] buffer, int ifirst, int ilast) {
        for (int i = ifirst; i <= ilast; ++i) {
            if (buffer[i] == 64) continue;
            return false;
        }
        return true;
    }

    @Override
    public void putLong(long value, byte[] buffer) throws IllegalArgumentException {
        this.putLong(value, buffer, 0);
    }

    @Override
    public void putLong(long value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        if (this.blankWhenZero && value == 0L) {
            for (int i = ifirst; i <= ilast; ++i) {
                buffer[i] = 64;
            }
            return;
        }
        if (value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
        int signNibble = -16;
        if (this.signed) {
            int signByte = 78;
            if (value < 0L) {
                if (value < this.minValue) {
                    throw new IllegalArgumentException("" + value);
                }
                signNibble = -48;
                signByte = 96;
                value = -value;
            } else {
                signNibble = -64;
            }
            if (this.signExternal) {
                if (this.signTrailing) {
                    buffer[ilast--] = signByte;
                } else {
                    buffer[ifirst++] = signByte;
                }
            }
        } else if (value < 0L) {
            throw new IllegalArgumentException("" + value);
        }
        for (int i = ilast; i >= ifirst; --i) {
            if (value != 0L) {
                buffer[i] = (byte)(0xF0 | (int)(value % 10L));
                value /= 10L;
                continue;
            }
            buffer[i] = -16;
        }
        if (this.signed && !this.signExternal) {
            if (this.signTrailing) {
                buffer[ilast] = (byte)(buffer[ilast] & 0xF | signNibble);
            } else {
                buffer[ifirst] = (byte)(buffer[ifirst] & 0xF | signNibble);
            }
        }
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    public boolean equals(Long aLong, long along) {
        if (aLong == null) {
            return false;
        }
        return aLong == along;
    }

    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public boolean isSignExternal() {
        return this.signExternal;
    }

    public boolean isSignTrailing() {
        return this.signTrailing;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setSignExternal(boolean signExternal) {
        this.signExternal = signExternal;
    }

    protected void rangeCheck(long value) {
        if (value < this.minValue || value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
    }

    static {
        long itoten = 1L;
        for (int i = 0; i < MAX_VALUES.length; ++i) {
            ExternalDecimalAsLongField.MAX_VALUES[i] = itoten - 1L;
            itoten *= 10L;
        }
    }
}

