/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.IntAccessor;

public class ExternalDecimalAsIntField
implements IntAccessor {
    private int offset;
    private int length;
    private int precision;
    private boolean signed;
    private boolean signTrailing;
    private boolean signExternal;
    private boolean blankWhenZero;
    protected final int minValue;
    protected final int maxValue;
    private static final byte EBCDIC_MINUS = 96;
    private static final byte EBCDIC_PLUS = 78;
    private static final byte EBCDIC_SPACE = 64;
    private static final int MAX_PRECISION = 9;
    private static final int[] MAX_VALUES = new int[10];

    public ExternalDecimalAsIntField(int offset, int precision, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        if (precision < 1 || precision > 9) {
            throw new IllegalArgumentException("precision=" + precision);
        }
        this.offset = offset;
        this.precision = precision;
        this.signed = signed;
        this.signTrailing = signed && signTrailing;
        this.signExternal = signed && signExternal;
        this.blankWhenZero = blankWhenZero;
        this.length = precision + (this.signExternal ? 1 : 0);
        this.maxValue = MAX_VALUES[precision];
        this.minValue = -this.maxValue;
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getInt(byte[] buffer) {
        return this.getInt(buffer, 0);
    }

    @Override
    public int getInt(byte[] buffer, int bufOffset) {
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        if (this.blankWhenZero && this.isAllBlanks(buffer, ifirst, ilast)) {
            return 0;
        }
        boolean effectiveSign = true;
        if (this.signed) {
            if (this.signExternal) {
                effectiveSign = this.signTrailing ? buffer[ilast--] != 96 : buffer[ifirst++] != 96;
            } else {
                int signHighNibble = buffer[this.signTrailing ? ilast : ifirst] & 0xF0;
                effectiveSign = signHighNibble != 208 && signHighNibble != 176;
            }
        }
        int value = 0;
        for (int i = ifirst; i <= ilast; ++i) {
            value = value * 10 + (buffer[i] & 0xF);
        }
        return effectiveSign ? value : -value;
    }

    private boolean isAllBlanks(byte[] buffer, int ifirst, int ilast) {
        for (int i = ifirst; i <= ilast; ++i) {
            if (buffer[i] == 64) continue;
            return false;
        }
        return true;
    }

    @Override
    public void putInt(int value, byte[] buffer) throws IllegalArgumentException {
        this.putInt(value, buffer, 0);
    }

    @Override
    public void putInt(int value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        if (this.blankWhenZero && value == 0) {
            for (int i = ifirst; i <= ilast; ++i) {
                buffer[i] = 64;
            }
            return;
        }
        if (value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
        int signNibble = -16;
        if (this.signed) {
            int signByte = 78;
            if (value < 0) {
                if (value < this.minValue) {
                    throw new IllegalArgumentException("" + value);
                }
                signNibble = -48;
                signByte = 96;
                value = -value;
            } else {
                signNibble = -64;
            }
            if (this.signExternal) {
                if (this.signTrailing) {
                    buffer[ilast--] = signByte;
                } else {
                    buffer[ifirst++] = signByte;
                }
            }
        } else if (value < 0) {
            throw new IllegalArgumentException("" + value);
        }
        for (int i = ilast; i >= ifirst; --i) {
            if (value != 0) {
                buffer[i] = (byte)(0xF0 | value % 10);
                value /= 10;
                continue;
            }
            buffer[i] = -16;
        }
        if (this.signed && !this.signExternal) {
            if (this.signTrailing) {
                buffer[ilast] = (byte)(buffer[ilast] & 0xF | signNibble);
            } else {
                buffer[ifirst] = (byte)(buffer[ifirst] & 0xF | signNibble);
            }
        }
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    public boolean equals(Integer anInteger, int anInt) {
        if (anInteger == null) {
            return false;
        }
        return anInteger == anInt;
    }

    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isSignExternal() {
        return this.signExternal;
    }

    public boolean isSignTrailing() {
        return this.signTrailing;
    }

    protected void rangeCheck(int value) {
        if (value < this.minValue || value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
    }

    static {
        int itoten = 1;
        for (int i = 0; i < MAX_VALUES.length; ++i) {
            ExternalDecimalAsIntField.MAX_VALUES[i] = itoten - 1;
            itoten *= 10;
        }
    }
}

