/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BigIntegerAccessor;
import com.ibm.jzos.fields.ExternalDecimalAsLongField;
import java.math.BigInteger;

public class ExternalDecimalAsBigIntegerField
implements BigIntegerAccessor {
    private int offset;
    private int length;
    private int precision;
    private int scale;
    private boolean signed;
    private boolean signTrailing;
    private boolean signExternal;
    private boolean blankWhenZero;
    private BigInteger scaleFactor;
    private ExternalDecimalAsLongField longConverter;
    private long longScaleFactor = 1L;
    private static final byte EBCDIC_MINUS = 96;
    private static final byte EBCDIC_PLUS = 78;
    private static final byte EBCDIC_SPACE = 64;

    public ExternalDecimalAsBigIntegerField(int offset, int precision, int scale, boolean signed, boolean signTrailing, boolean signExternal, boolean blankWhenZero) {
        if (precision < 1 || precision > 31) {
            throw new IllegalArgumentException("precision");
        }
        if (scale > 0) {
            throw new IllegalArgumentException("scale must be <= 0");
        }
        if (scale < 0) {
            this.scaleFactor = BigInteger.valueOf(10L).pow(-scale);
        }
        this.offset = offset;
        this.precision = precision;
        this.scale = scale;
        this.signed = signed;
        this.signTrailing = signed && signTrailing;
        this.signExternal = signed && signExternal;
        this.length = precision + (this.signExternal ? 1 : 0);
        this.blankWhenZero = blankWhenZero;
        if (precision - scale <= 18) {
            this.longConverter = new ExternalDecimalAsLongField(offset, precision, signed, signTrailing, signExternal, blankWhenZero);
            for (int i = scale; i < 0; ++i) {
                this.longScaleFactor *= 10L;
            }
        }
    }

    @Override
    public int getByteLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
        if (this.longConverter != null) {
            this.longConverter.setOffset(offset);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    @Override
    public BigInteger getBigInteger(byte[] buffer) {
        return this.getBigInteger(buffer, 0);
    }

    @Override
    public BigInteger getBigInteger(byte[] buffer, int bufOffset) {
        int i;
        if (this.longConverter != null) {
            long unscaledLong = this.longConverter.getLong(buffer, bufOffset);
            return BigInteger.valueOf(unscaledLong * this.longScaleFactor);
        }
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        if (this.blankWhenZero && this.isAllBlanks(buffer, ifirst, ilast)) {
            return BigInteger.ZERO;
        }
        boolean effectiveSign = true;
        if (this.signed) {
            if (this.signExternal) {
                effectiveSign = this.signTrailing ? buffer[ilast--] != 96 : buffer[ifirst++] != 96;
            } else {
                int signHighNibble = buffer[this.signTrailing ? ilast : ifirst] & 0xF0;
                effectiveSign = signHighNibble != 208 && signHighNibble != 176;
            }
        }
        StringBuffer sb = new StringBuffer();
        if (!effectiveSign) {
            sb.append('-');
        }
        for (i = ifirst; i <= ilast; ++i) {
            sb.append((char)(48 + (buffer[i] & 0xF)));
        }
        for (i = this.scale; i < 0; ++i) {
            sb.append('0');
        }
        return new BigInteger(sb.toString());
    }

    private boolean isAllBlanks(byte[] buffer, int ifirst, int ilast) {
        for (int i = ifirst; i <= ilast; ++i) {
            if (buffer[i] == 64) continue;
            return false;
        }
        return true;
    }

    @Override
    public void putBigInteger(BigInteger value, byte[] buffer) throws IllegalArgumentException {
        this.putBigInteger(value, buffer, 0);
    }

    @Override
    public void putBigInteger(BigInteger value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        if (this.longConverter != null) {
            long unscaledLong = value.longValue() / this.longScaleFactor;
            this.longConverter.putLong(unscaledLong, buffer, bufOffset);
            return;
        }
        if (this.scale < 0) {
            value = value.divide(this.scaleFactor);
        }
        int ifirst = this.offset + bufOffset;
        int ilast = ifirst + this.length - 1;
        int valueSign = value.compareTo(BigInteger.ZERO);
        value = value.abs();
        if (this.blankWhenZero && valueSign == 0) {
            for (int i = ifirst; i <= ilast; ++i) {
                buffer[i] = 64;
            }
            return;
        }
        char[] ca = value.toString().toCharArray();
        int cafirst = 0;
        int calast = ca.length - 1;
        int signNibble = -16;
        if (this.signed) {
            int signByte = 78;
            if (valueSign < 0) {
                signNibble = -48;
                signByte = 96;
            } else {
                signNibble = -64;
            }
            if (this.signExternal) {
                if (this.signTrailing) {
                    buffer[ilast--] = signByte;
                } else {
                    buffer[ifirst++] = signByte;
                }
            }
        } else if (valueSign < 0) {
            throw new IllegalArgumentException("value out of range");
        }
        for (int i = ilast; i >= ifirst; --i) {
            if (calast >= cafirst) {
                int d = ca[calast--] - 48;
                buffer[i] = (byte)(0xF0 | d);
                continue;
            }
            buffer[i] = -16;
        }
        if (calast >= cafirst) {
            throw new IllegalArgumentException("" + value);
        }
        if (this.signed && !this.signExternal) {
            if (this.signTrailing) {
                buffer[ilast] = (byte)(buffer[ilast] & 0xF | signNibble);
            } else {
                buffer[ifirst] = (byte)(buffer[ifirst] & 0xF | signNibble);
            }
        }
    }

    public boolean equals(BigInteger a, BigInteger b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isSignExternal() {
        return this.signExternal;
    }

    public boolean isSignTrailing() {
        return this.signTrailing;
    }
}

