/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.BinaryAsBigDecimalField;
import com.ibm.jzos.fields.BinaryAsBigIntegerField;
import com.ibm.jzos.fields.BinaryAsIntField;
import com.ibm.jzos.fields.BinaryAsLongField;
import com.ibm.jzos.fields.DatatypeFactory;
import com.ibm.jzos.fields.ExternalFloatField;
import com.ibm.jzos.fields.Field;
import java.math.BigInteger;

public class CobolDatatypeFactory
extends DatatypeFactory {
    @Override
    public BinaryAsLongField getBinaryAsLongField(int precision, boolean signed) {
        return super.getBinaryAsLongField(this.getBinaryLength(precision), signed);
    }

    @Override
    public BinaryAsIntField getBinaryAsIntField(int precision, boolean signed) {
        return super.getBinaryAsIntField(this.getBinaryLength(precision), signed);
    }

    @Override
    public BinaryAsBigDecimalField getBinaryAsBigDecimalField(int precision, int scale, boolean signed) {
        return super.getBinaryAsBigDecimalField(this.getBinaryLength(precision), scale, signed);
    }

    @Override
    public BinaryAsBigIntegerField getBinaryAsBigIntegerField(int precision, int scale, boolean signed) {
        return super.getBinaryAsBigIntegerField(this.getBinaryLength(precision), scale, signed);
    }

    public Field getBinaryField(int precision, int scale, boolean signed, boolean comp5) {
        if (scale > 0) {
            return this.getBinaryAsBigDecimalField(precision, scale, signed);
        }
        if (scale < 0) {
            return this.getBinaryAsBigIntegerField(precision, scale, signed);
        }
        int byteLength = this.getBinaryLength(precision);
        switch (byteLength) {
            case 2: {
                return this.getBinaryAsIntField(precision, signed);
            }
            case 4: {
                if (!signed && comp5) {
                    return this.getBinaryAsLongField(precision, signed);
                }
                return this.getBinaryAsIntField(precision, signed);
            }
            case 8: {
                if (!signed && comp5) {
                    return this.getBinaryAsBigIntegerField(precision, 0, signed);
                }
                return this.getBinaryAsLongField(precision, signed);
            }
        }
        return this.getBinaryAsBigIntegerField(precision, 0, signed);
    }

    public ExternalFloatField getExternalFloatField(int precision, int scale, boolean showMantissaPlusSign, boolean showExponentPlusSign, boolean impliedDecimalPoint) {
        ExternalFloatField field = new ExternalFloatField(this.offset, precision, scale, showMantissaPlusSign, showExponentPlusSign, impliedDecimalPoint);
        this.advanceOffset(field);
        return field;
    }

    @Override
    public Field getPackedDecimalField(int precision, int scale, boolean signed) {
        if (scale > 0) {
            return this.getPackedDecimalAsBigDecimalField(precision, scale, signed);
        }
        if (scale < 0) {
            return this.getPackedDecimalAsBigIntegerField(precision, scale, signed);
        }
        if (precision <= 9) {
            return this.getPackedDecimalAsIntField(precision, signed);
        }
        if (precision <= 18) {
            return this.getPackedDecimalAsLongField(precision, signed);
        }
        if (precision <= 31) {
            return this.getPackedDecimalAsBigIntegerField(precision, scale, signed);
        }
        throw new IllegalArgumentException("precision too big");
    }

    private int getBinaryLength(int precision) {
        int length;
        if (precision <= 4) {
            length = 2;
        } else if (precision <= 9) {
            length = 4;
        } else if (precision <= 18) {
            length = 8;
        } else {
            BigInteger maxPosValue = BigInteger.valueOf(10L).pow(precision).subtract(BigInteger.valueOf(1L));
            length = maxPosValue.bitLength() + 0;
        }
        return length;
    }
}

