/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.Messages;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZFileVariableRecordReader;

class ZFileVariableSpannedRecordReader
extends ZFileVariableRecordReader {
    private byte[] record;
    private int partialRecordLength;
    public static final int SDW_LEN = 4;
    public static final byte SEGMENT_ONLY = 0;
    public static final byte SEGMENT_FIRST = 1;
    public static final byte SEGMENT_LAST = 2;
    public static final byte SEGMENT_MIDDLE = 3;

    ZFileVariableSpannedRecordReader(ZFile zFile) throws ZFileException {
        super(zFile);
        this.record = new byte[this.maxRecLen];
        this.partialRecordLength = 0;
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws ZFileException {
        int recordLength = this.deblockSegmentsIntoRecord();
        if (recordLength == -1) {
            return -1;
        }
        if (len > recordLength) {
            len = recordLength;
        }
        System.arraycopy(this.record, 0, buf, offset, len);
        return len;
    }

    private int deblockSegmentsIntoRecord() throws ZFileException {
        int remainingBlockLen;
        block6: while ((remainingBlockLen = this.currentBlockLength - this.currentOffset) > 0 || this.readNextBlock()) {
            remainingBlockLen = this.currentBlockLength - this.currentOffset;
            if (remainingBlockLen < 4) {
                this.throwInvalidPartialSdwException();
            }
            int segLen = ByteUtil.bytesAsInt(this.block, this.currentOffset, 2);
            byte segControlCode = this.block[this.currentOffset + 2];
            if ((segLen -= 4) < 0 || segLen > remainingBlockLen - 4) {
                this.throwInvalidSdwException(segLen + 4);
            }
            if (this.partialRecordLength + segLen > this.maxRecLen) {
                this.throwInvalidRecordLengthException(this.partialRecordLength + segLen);
            }
            this.currentOffset += 4;
            System.arraycopy(this.block, this.currentOffset, this.record, this.partialRecordLength, segLen);
            this.partialRecordLength += segLen;
            this.currentOffset += segLen;
            switch (segControlCode) {
                case 0: {
                    if (this.partialRecordLength > segLen) {
                        this.throwSegmentCodeSequenceException();
                    }
                }
                case 2: {
                    int recordLength = this.partialRecordLength;
                    this.partialRecordLength = 0;
                    return recordLength;
                }
                case 1: {
                    if (this.partialRecordLength > segLen) {
                        this.throwSegmentCodeSequenceException();
                    }
                }
                case 3: {
                    continue block6;
                }
            }
            this.throwSegmentCodeException(segControlCode);
        }
        return -1;
    }

    private void throwInvalidPartialSdwException() throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableSpannedRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableSpannedRecordReader.AtOffset") + this.currentOffset + Messages.getString("ZFileVariableSpannedRecordReader.ContainsInvalidPartialSDW"), -1);
    }

    private void throwInvalidSdwException(int sdwLen) throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableSpannedRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableSpannedRecordReader.AtOffset") + this.currentOffset + Messages.getString("ZFileVariableSpannedRecordReader.ContainsInvalidSDW") + sdwLen, -1);
    }

    private void throwInvalidRecordLengthException(int recLen) throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableSpannedRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableSpannedRecordReader.AtOffset") + this.currentOffset + Messages.getString("ZFileVariableSpannedRecordReader.ContainsRecordLen") + recLen + Messages.getString("ZFileVariableSpannedRecordReader.LargerThanMaxLen") + this.maxRecLen, -1);
    }

    private void throwSegmentCodeSequenceException() throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableSpannedRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableSpannedRecordReader.AtOffset") + (this.currentOffset - 4) + Messages.getString("ZFileVariableSpannedRecordReader.ContainsInvalidSegControlSeq"), -1);
    }

    private void throwSegmentCodeException(byte segControlCode) throws ZFileException {
        throw new ZFileException(this.zFile.getFilename(), Messages.getString("ZFileVariableSpannedRecordReader.BlockNum") + this.zFile.getRecordCount() + Messages.getString("ZFileVariableSpannedRecordReader.AtOffset") + (this.currentOffset - 4) + Messages.getString("ZFileVariableSpannedRecordReader.ContainsInvalidSegControlCode") + Integer.toHexString(segControlCode), -1);
    }
}

