/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.DSCB;
import com.ibm.jzos.DatasetVolumeList;
import com.ibm.jzos.Enqueue;
import com.ibm.jzos.EnqueueException;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.Format3DSCB;
import com.ibm.jzos.Format8DSCB;
import com.ibm.jzos.Format9DSCB;
import com.ibm.jzos.JFCB;
import com.ibm.jzos.Messages;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFileConstants;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.os390.security.PlatformThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZFile
implements ZFileConstants {
    private String name;
    private String options;
    private long hFileInfo;
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final boolean IS_64_BIT;
    private static final int LOCATE_LONG_LEN;
    private String ddname;
    private String pdsName;
    private String memberName;
    private Enqueue enqMember;
    private Enqueue enqDSN;

    public static native String allocDummyDDName() throws RcException;

    public static void bpxwdyn(String command) throws RcException {
        try {
            ZFile.basicBpxwdyn(command);
        }
        catch (RcException rce) {
            String errMsg;
            int rc = rce.getRc();
            if (rc == 20) {
                errMsg = Messages.getString("ZFile.BpxwdynParmlist");
            } else if (rc <= -21 && rc >= -9999) {
                int keyerr = 0 - rc - 20;
                errMsg = Messages.getString("ZFile.BpxwdynKeyword") + " " + keyerr;
            } else if (rc < -10000 && rc > -10100) {
                int msgerr = (0 - rc) % 100;
                errMsg = Messages.getString("ZFile.BpxwdynMsgproc") + msgerr;
            } else {
                int s99err = rc >>> 16;
                int s99info = rc & 0xFFFF;
                errMsg = Messages.getString("ZFile.BpxwdynS99Error") + Integer.toHexString(s99err) + "/0x" + Integer.toHexString(s99info);
            }
            ZUtil.logDiagnostic(4, errMsg + "; cmd=" + command);
            throw new RcException(errMsg, rc);
        }
    }

    public static boolean ddExists(String ddname) throws ZFileException {
        if (ZFile.isDDFilename(ddname = ddname.toUpperCase().trim())) {
            ddname = ddname.substring(ddname.indexOf(58) + 1);
        }
        if (ddname.indexOf(40) > 0) {
            throw new IllegalArgumentException(Messages.getString("ZFile.PdsExistsNotSupported"));
        }
        return ZFile.basicDDExists(ddname);
    }

    public static boolean dsExists(String dsn) throws ZFileException {
        String fqdsn = ZFile.getFullyQualifiedDSN(dsn);
        String[] dsnAndMember = ZFile.splitDsnAndMember(fqdsn);
        String dsnWithoutMember = dsnAndMember[0];
        String member = dsnAndMember[1];
        if (member != null) {
            char memfirst = member.charAt(0);
            if (memfirst == '+') {
                return false;
            }
            if (memfirst == '0' || memfirst == '-') {
                try {
                    DatasetVolumeList dsvl = new DatasetVolumeList();
                    ZFile.locateDSN(dsn, dsvl);
                    return dsvl.getTotalVolumesCount() > 0;
                }
                catch (RcException rce) {
                    return false;
                }
            }
            dsnWithoutMember = ZFile.getSlashSlashQuotedDSN(dsnWithoutMember, true);
            PdsDirectory pdsDir = null;
            try {
                pdsDir = new PdsDirectory(dsnWithoutMember);
                PdsDirectory.Iterator iterator = (PdsDirectory.Iterator)pdsDir.iterator();
                boolean bl = iterator.find(member) != null;
                return bl;
            }
            catch (ZFileException zfe) {
                if (zfe.getErrno() == 129 || zfe.getErrno() == 49) {
                    boolean bl = false;
                    return bl;
                }
                throw zfe;
            }
            catch (Exception rte) {
                throw new ZFileException(dsnWithoutMember, rte.getMessage(), -1);
            }
            finally {
                if (pdsDir != null) {
                    try {
                        pdsDir.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            DatasetVolumeList dsvl = new DatasetVolumeList();
            ZFile.locateDSN(dsn, dsvl);
            return dsvl.getTotalVolumesCount() > 0;
        }
        catch (RcException rce) {
            return false;
        }
    }

    public static boolean exists(String filename) throws ZFileException {
        String upperFilename = filename.toUpperCase().trim();
        if (ZFile.isDDFilename(upperFilename) && upperFilename.indexOf(40) < 0) {
            return ZFile.ddExists(upperFilename);
        }
        if (filename.startsWith("//") && !filename.startsWith("///")) {
            return ZFile.dsExists(filename);
        }
        throw new ZFileException(filename, Messages.getString("ZFile.InvalidFilename"), 0);
    }

    public static String getFullyQualifiedDSN(String dsn) {
        return ZFile.getFullyQualifiedDSN(dsn, false);
    }

    public static String getFullyQualifiedDSN(String dsn, boolean isFullyQualified) {
        if (dsn == null) {
            throw new NullPointerException(Messages.getString("ZFile.NullDatasetName"));
        }
        if ((dsn = dsn.toUpperCase().trim()).startsWith("//")) {
            dsn = dsn.substring(2);
        }
        if (dsn.startsWith("*DD:")) {
            dsn = dsn.substring(1);
        } else if (!dsn.startsWith("DD:") && !dsn.startsWith("&")) {
            String hlq;
            if (dsn.charAt(0) == '\'') {
                int len = dsn.length();
                if (dsn.charAt(len - 1) == '\'') {
                    --len;
                }
                dsn = dsn.substring(1, len);
            } else if (!isFullyQualified && (hlq = ZFile.getDefaultHLQ()) != null && hlq.length() > 0) {
                dsn = hlq + "." + dsn;
            }
        }
        return dsn;
    }

    public static String getSlashSlashQuotedDSN(String dsn) {
        return ZFile.getSlashSlashQuotedDSN(dsn, false);
    }

    public static String getSlashSlashQuotedDSN(String dsn, boolean isFullyQualified) {
        String fqdsn = ZFile.getFullyQualifiedDSN(dsn, isFullyQualified);
        if (fqdsn.startsWith("DD:") || dsn.startsWith("&")) {
            return "//" + fqdsn;
        }
        return "//'" + fqdsn + '\'';
    }

    public static String getDefaultHLQ() {
        String tsoPrefix = ZUtil.getCurrentTsoPrefix();
        if (tsoPrefix != null && tsoPrefix.length() > 0) {
            return tsoPrefix;
        }
        return PlatformThread.getUserName();
    }

    public ZFile(String name, String options) throws ZFileException {
        ZFile.checkSecurityManager(name, options);
        this.doZFileOpen(name, options);
    }

    public ZFile(String name, String options, int flags) throws ZFileException, RcException, EnqueueException {
        ZFile.checkSecurityManager(name, options);
        String fqdsn = ZFile.getFullyQualifiedDSN(name);
        if (flags != 0) {
            if (ZFile.isDDFilename(name)) {
                ZUtil.logDiagnostic(3, Messages.getString("ZFile.DDNameNotSupported") + " " + name);
            } else if (flags == 1) {
                this.doAllocShr(fqdsn);
            } else if (flags == 3) {
                if (!this.isWriteMode(options)) {
                    ZUtil.logDiagnostic(4, Messages.getString("ZFile.InvalidPdsEnqOption") + " " + fqdsn);
                    this.doAllocShr(fqdsn);
                } else {
                    this.splitExistingPdsAndMember(fqdsn);
                    if (this.pdsName != null && this.memberName != null) {
                        try {
                            this.doAllocShr(this.pdsName);
                            this.doEnqMember();
                            this.doEnqDSN();
                        }
                        catch (RcException rce) {
                            try {
                                this.doDeqAndUnalloc();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw rce;
                        }
                    }
                    ZUtil.logDiagnostic(3, Messages.getString("ZFile.InvalidPdsEnqOption") + " " + fqdsn);
                }
            } else {
                ZUtil.logDiagnostic(3, Messages.getString("ZFile.InvalidFlags") + " 0x" + Integer.toHexString(flags));
            }
        }
        this.doZFileOpen(name, options);
    }

    private void doZFileOpen(String name, String options) throws ZFileException {
        this.name = name;
        this.options = options;
        if (this.ddname != null) {
            name = "//DD:" + this.ddname;
            if (this.memberName != null) {
                name = name + "(" + this.memberName + ")";
            }
        }
        try {
            this.hFileInfo = this.fopen(name, options);
        }
        catch (ZFileException zfe) {
            try {
                this.doDeqAndUnalloc();
            }
            catch (RcException rce) {
                ZUtil.logDiagnostic(1, Messages.getString("ZFile.ErrorDeqAfterOpenFailure") + " - " + rce.getMessage());
            }
            throw zfe;
        }
    }

    private ZFile() throws ZFileException {
    }

    static ZFile usingStderr() throws ZFileException {
        ZFile stderr = new ZFile();
        stderr.name = "stderr";
        stderr.options = "w";
        stderr.hFileInfo = stderr.openStderr();
        return stderr;
    }

    public int getBlksize() throws ZFileException {
        return this.getBlksize(this.getHFileInfo());
    }

    public long getByteCount() throws ZFileException {
        return this.getByteCount(this.getHFileInfo());
    }

    public int getDsorg() throws ZFileException {
        return this.getDsorg(this.getHFileInfo());
    }

    public byte[] getPos() throws ZFileException {
        return this.fgetpos(this.getHFileInfo());
    }

    public String getActualFilename() throws ZFileException {
        return this.getActualFilename(this.getHFileInfo());
    }

    public String getFilename() {
        return this.name;
    }

    public String getOptions() {
        return this.options;
    }

    public int getOpenMode() throws ZFileException {
        return this.getOpenMode(this.getHFileInfo());
    }

    public int getModeFlags() throws ZFileException {
        return this.getModeFlags(this.getHFileInfo());
    }

    public int getDevice() throws ZFileException {
        return this.getDevice(this.getHFileInfo());
    }

    public InputStream getInputStream() {
        if (this.getOptions() == null || !this.getOptions().startsWith("r")) {
            throw new IllegalStateException("File was not opened in read mode");
        }
        return new InputStream(){

            @Override
            public void close() throws IOException {
                ZFile.this.close();
            }

            @Override
            public int read() throws IOException {
                byte[] buf = new byte[1];
                int nRead = ZFile.this.read(buf);
                if (nRead < 0) {
                    return nRead;
                }
                return buf[0] & 0xFF;
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return ZFile.this.read(buf, off, len);
            }

            @Override
            public int read(byte[] buf) throws IOException {
                return ZFile.this.read(buf);
            }
        };
    }

    public int getLrecl() throws ZFileException {
        return this.getLrecl(this.getHFileInfo());
    }

    public OutputStream getOutputStream() {
        if (!this.isWriteMode(this.getOptions())) {
            throw new IllegalStateException("File was not opened in write mode");
        }
        return new OutputStream(){

            @Override
            public void close() throws IOException {
                ZFile.this.close();
            }

            @Override
            public void flush() throws IOException {
                ZFile.this.flush();
            }

            @Override
            public void write(int b) throws IOException {
                byte[] buf = new byte[]{(byte)b};
                ZFile.this.write(buf);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ZFile.this.write(b, off, len);
            }

            @Override
            public void write(byte[] b) throws IOException {
                ZFile.this.write(b);
            }
        };
    }

    public String getRecfm() throws ZFileException {
        int recfm = this.getRecfmBits();
        StringBuffer sb = new StringBuffer(4);
        if ((recfm & 1) != 0) {
            sb.append("F");
        } else if ((recfm & 2) != 0) {
            sb.append("V");
        } else if ((recfm & 4) != 0) {
            sb.append("U");
        } else {
            return "";
        }
        if ((recfm & 8) != 0) {
            sb.append("B");
        }
        if ((recfm & 0x10) != 0) {
            sb.append("S");
        }
        if ((recfm & 0x20) != 0) {
            sb.append("M");
        }
        if ((recfm & 0x40) != 0) {
            sb.append("A");
        }
        return sb.toString();
    }

    public int getRecfmBits() throws ZFileException {
        return this.getRecfm(this.getHFileInfo());
    }

    public long getRecordCount() throws ZFileException {
        return this.getRecordCount(this.getHFileInfo());
    }

    public int getVsamKeyLength() throws ZFileException {
        return this.getVsamKeyLength(this.getHFileInfo());
    }

    public int getVsamType() throws ZFileException {
        return this.getVsamType(this.getHFileInfo());
    }

    public long getVsamRBA() throws ZFileException {
        return this.getVsamRBA(this.getHFileInfo());
    }

    public synchronized void close() throws ZFileException, RcException {
        try {
            if (this.hFileInfo != 0L) {
                this.fclose(this.getHFileInfo());
            }
            this.doDeqAndUnalloc();
        }
        catch (ZFileException zfe) {
            try {
                this.doDeqAndUnalloc();
            }
            catch (RcException rce) {
                ZUtil.logDiagnostic(1, Messages.getString("ZFile.ErrorDeqAfterCloseFailure") + " - " + rce.getMessage());
            }
            throw zfe;
        }
        finally {
            this.hFileInfo = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doDeqAndUnalloc() throws RcException {
        try {
            RcException rc1 = null;
            RcException rc2 = null;
            try {
                this.doReleaseEnqDSN();
            }
            catch (RcException rce) {
                rc1 = rce;
            }
            try {
                this.doReleaseEnqMem();
            }
            catch (RcException rce) {
                rc2 = rce;
            }
            if (rc1 != null) {
                throw rc1;
            }
            if (rc2 != null) {
                throw rc2;
            }
        }
        finally {
            this.doUnallocShr();
        }
    }

    private void doReleaseEnqMem() throws RcException {
        if (this.enqMember != null) {
            try {
                this.enqMember.release();
                ZUtil.logDiagnostic(5, "ZFile: Released ENQ (MEMBER) on \"" + this.enqMember.getRName() + "\"");
            }
            finally {
                this.enqMember = null;
            }
        }
    }

    private void doReleaseEnqDSN() throws RcException {
        if (this.enqDSN != null) {
            try {
                this.enqDSN.release();
                ZUtil.logDiagnostic(5, "ZFile: Released ENQ (PDS DSN) on \"" + this.enqDSN.getRName() + "\"");
            }
            finally {
                this.enqDSN = null;
            }
        }
    }

    public void flush() throws ZFileException {
        this.fflush(this.getHFileInfo());
    }

    public boolean locate(long recordNumberOrRBA, int options) throws ZFileException {
        if (recordNumberOrRBA < 0L || recordNumberOrRBA > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Messages.getString("ZFile.InvalidUnsignedInt"));
        }
        byte[] bytes = new byte[LOCATE_LONG_LEN];
        ByteUtil.putLong(recordNumberOrRBA, bytes, 0, LOCATE_LONG_LEN);
        return this.locate(bytes, 0, LOCATE_LONG_LEN, options);
    }

    public boolean locate(byte[] key, int options) throws ZFileException {
        return this.flocate(this.getHFileInfo(), key, 0, key.length, options);
    }

    public boolean locate(byte[] key, int offset, int length, int options) throws ZFileException {
        return this.flocate(this.getHFileInfo(), key, offset, length, options);
    }

    public boolean locate_unlocked(long recordNumberOrRBA, int options) throws ZFileException {
        if (recordNumberOrRBA < 0L || recordNumberOrRBA > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(Messages.getString("ZFile.InvalidUnsignedInt"));
        }
        byte[] bytes = new byte[LOCATE_LONG_LEN];
        ByteUtil.putLong(recordNumberOrRBA, bytes, 0, LOCATE_LONG_LEN);
        return this.locate_unlocked(bytes, 0, LOCATE_LONG_LEN, options);
    }

    public boolean locate_unlocked(byte[] key, int options) throws ZFileException {
        return this.flocateUnlocked(this.getHFileInfo(), key, 0, key.length, options);
    }

    public boolean locate_unlocked(byte[] key, int offset, int length, int options) throws ZFileException {
        return this.flocateUnlocked(this.getHFileInfo(), key, offset, length, options);
    }

    public static String[] locateDSN(String dsn) throws RcException {
        DatasetVolumeList dsvl = new DatasetVolumeList();
        ZFile.locateDSN(dsn, dsvl);
        return dsvl.getVolumes();
    }

    public static void locateDSN(String dsn, DatasetVolumeList dsvl) throws RcException {
        ZFile.basicLocateDSN(ZFile.getFullyQualifiedDSN(dsn), dsvl.getBytes());
    }

    private static native void basicLocateDSN(String var0, byte[] var1);

    public static void makeFifo(String path, int mode) throws ZFileException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(path);
        }
        ZFile.basicMakeFifo(path, mode);
    }

    private static native void basicMakeFifo(String var0, int var1) throws ZFileException;

    public static Format1DSCB obtainDSN(String dsn, String volume) throws RcException {
        DSCB[] dscbs = ZFile.readDSCBChain(dsn, volume);
        if (dscbs.length == 0 || !(dscbs[0] instanceof Format1DSCB)) {
            return null;
        }
        return (Format1DSCB)dscbs[0];
    }

    public static DSCB[] readDSCBChain(String dsn, String volume) throws RcException {
        int DSCB_LEN = 140;
        String fqdsn = ZFile.getFullyQualifiedDSN(dsn);
        byte[] dscb_buffer = ZFile.basicObtainDSN(fqdsn, volume.toUpperCase());
        if (dscb_buffer.length == 0) {
            return new DSCB[0];
        }
        if (dscb_buffer == null || dscb_buffer.length < DSCB_LEN) {
            throw new IllegalStateException(Messages.getString("ZFile.BadDscbBufferLength"));
        }
        int numDscbs = dscb_buffer.length / DSCB_LEN;
        DSCB[] dscbs = new DSCB[numDscbs];
        for (int i = 0; i < numDscbs; ++i) {
            byte[] bytes = new byte[DSCB_LEN];
            System.arraycopy(dscb_buffer, DSCB_LEN * i, bytes, 0, DSCB_LEN);
            Format1DSCB f1Dscb = new Format1DSCB(bytes);
            if (f1Dscb.getDS1FMTID().equals("1")) {
                dscbs[i] = f1Dscb;
                continue;
            }
            Format3DSCB f3Dscb = new Format3DSCB(bytes);
            if (f3Dscb.getDS3KEYID() == 0x3030303L) {
                dscbs[i] = f3Dscb;
                continue;
            }
            Format8DSCB f8Dscb = new Format8DSCB(bytes);
            if (f8Dscb.getDS1FMTID().equals("8")) {
                dscbs[i] = f8Dscb;
                continue;
            }
            Format9DSCB f9Dscb = new Format9DSCB(bytes);
            if (f9Dscb.getDS9KEYID() == 9) {
                dscbs[i] = f9Dscb;
                continue;
            }
            throw new IllegalStateException(Messages.getString("ZFile.UnrecognizedDscb"));
        }
        return dscbs;
    }

    public static JFCB readJFCB(String ddname) throws ZFileException {
        return Bsam.readJFCB(ddname);
    }

    private static native byte[] basicObtainDSN(String var0, String var1);

    public int read(byte[] buf) throws ZFileException {
        return this.fread(this.getHFileInfo(), buf, 0, buf.length);
    }

    public int read_unlocked(byte[] buf) throws ZFileException {
        return this.freadUnlocked(this.getHFileInfo(), buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws ZFileException {
        return this.fread(this.getHFileInfo(), buf, offset, len);
    }

    public int read_unlocked(byte[] buf, int offset, int len) throws ZFileException {
        return this.freadUnlocked(this.getHFileInfo(), buf, offset, len);
    }

    protected int readNop(byte[] buf) throws ZFileException {
        return this.freadNop(this.getHFileInfo(), buf, 0, buf.length);
    }

    protected int readNoJni(byte[] buf) throws ZFileException {
        return buf.length;
    }

    public void reopen(String options) throws ZFileException {
        this.freopen(this.getHFileInfo(), options);
        this.options = options;
    }

    public static void remove(String fileName) throws ZFileException {
        ZFile.checkSecurityManager(fileName, "d");
        ZFile.fremove(fileName);
    }

    public static void rename(String oldName, String newName) throws ZFileException {
        ZFile.checkSecurityManager(oldName, "d");
        ZFile.checkSecurityManager(newName, "w");
        ZFile.frename(oldName, newName);
    }

    public void rewind() throws ZFileException {
        this.rewind(this.getHFileInfo());
    }

    public void seek(long offset, int origin) throws ZFileException {
        this.fseeko(this.getHFileInfo(), offset, origin);
    }

    public void setPos(byte[] position) throws ZFileException {
        this.fsetpos(this.getHFileInfo(), position);
    }

    public long tell() throws ZFileException {
        return this.ftello(this.getHFileInfo());
    }

    public int update(byte[] buf) throws ZFileException {
        return this.fupdate(this.getHFileInfo(), buf, 0, buf.length);
    }

    public int update(byte[] buf, int offset, int length) throws ZFileException {
        return this.fupdate(this.getHFileInfo(), buf, offset, length);
    }

    public void delrec() throws ZFileException {
        this.fdelrec(this.getHFileInfo());
    }

    public void write(byte[] buf) throws ZFileException {
        this.fwrite(this.getHFileInfo(), buf, 0, buf.length);
    }

    public void write(byte[] buf, int offset, int len) throws ZFileException {
        this.fwrite(this.getHFileInfo(), buf, offset, len);
    }

    protected void writeNop(byte[] buf, int offset, int len) throws ZFileException {
        this.fwriteNop(this.getHFileInfo(), buf, offset, len);
    }

    protected void writeNoJni(byte[] buf, int offset, int len) throws ZFileException {
    }

    private long getHFileInfo() throws IllegalStateException {
        if (this.hFileInfo == 0L) {
            throw new IllegalStateException(Messages.getString("ZFile.NoNativeFileInfo"));
        }
        return this.hFileInfo;
    }

    static void checkSecurityManager(String filename, String options) throws ZFileException {
        if (!filename.startsWith("//") || filename.startsWith("///")) {
            throw new ZFileException(filename, Messages.getString("ZFile.InvalidFilename"), 99);
        }
        if (System.getSecurityManager() == null) {
            return;
        }
        String dsn = ZFile.getFullyQualifiedDSN(filename);
        StringBuffer securityName = new StringBuffer("/DATASET/");
        block4: for (int i = 0; i < dsn.length(); ++i) {
            char c = dsn.charAt(i);
            switch (c) {
                case '(': 
                case '.': {
                    securityName.append('/');
                    continue block4;
                }
                case ')': {
                    continue block4;
                }
                default: {
                    securityName.append(c);
                }
            }
        }
        if (options.startsWith("r")) {
            System.getSecurityManager().checkRead(securityName.toString());
        } else if (options.startsWith("d")) {
            System.getSecurityManager().checkDelete(securityName.toString());
        } else {
            System.getSecurityManager().checkWrite(securityName.toString());
        }
    }

    private static boolean isDDFilename(String filename) {
        String upperFilename = filename.toUpperCase();
        return upperFilename.startsWith("//DD:") || upperFilename.startsWith("DD:") || upperFilename.startsWith("//*DD:") || upperFilename.startsWith("*DD:");
    }

    private boolean isWriteMode(String options) {
        int comma = options.indexOf(44);
        String op = comma == -1 ? options : options.substring(0, comma);
        return op.startsWith("a") || op.startsWith("w") || op.startsWith("r") && op.indexOf(43) > 0;
    }

    private boolean doEnqMember() throws RcException {
        block5: {
            StringBuffer rnameMem = new StringBuffer();
            rnameMem.append(this.pdsName);
            while (rnameMem.length() < 44) {
                rnameMem.append(' ');
            }
            rnameMem.append(this.memberName);
            while (rnameMem.length() < 52) {
                rnameMem.append(' ');
            }
            this.enqMember = new Enqueue("SPFEDIT", rnameMem.toString());
            this.enqMember.setScope(3);
            this.enqMember.setControl(2);
            this.enqMember.setContentionActFail();
            try {
                this.enqMember.obtain();
                ZUtil.logDiagnostic(5, "ZFile: Obtained ENQ on SPFEDIT/\"" + rnameMem + "\"");
            }
            catch (RcException rce) {
                if (rce.getRc() == 263181) break block5;
                if (rce.getRc() == 263172) {
                    ZUtil.logDiagnostic(3, Messages.getString("ZFile.PDSMemberInUse") + " " + this.pdsName + "(" + this.memberName + ")");
                }
                this.enqMember = null;
                throw rce;
            }
        }
        return true;
    }

    private void doEnqDSN() throws RcException {
        StringBuffer rnameDSN = new StringBuffer();
        rnameDSN.append(this.pdsName);
        while (rnameDSN.length() < 44) {
            rnameDSN.append(' ');
        }
        this.enqDSN = new Enqueue("SPFEDIT", rnameDSN.toString());
        this.enqDSN.setScope(3);
        this.enqDSN.setControl(2);
        this.enqDSN.setContentionActWait();
        try {
            this.enqDSN.obtain();
            ZUtil.logDiagnostic(5, "ZFile: Obtained ENQ on SPFEDIT/\"" + rnameDSN + "\"");
        }
        catch (RcException rce) {
            if (rce.getRc() == 263181) {
                ZUtil.logDiagnostic(5, "ZFile: Enqueue.ISGENQ_RSN_UNPROTECTEDQNAME");
            }
            if (rce.getRc() == 263172) {
                ZUtil.logDiagnostic(3, Messages.getString("ZFile.PDSInUse") + " " + this.pdsName);
            }
            this.enqDSN = null;
            throw rce;
        }
    }

    private synchronized void doAllocShr(String fqdsn) throws RcException {
        this.ddname = ZFile.allocDummyDDName();
        try {
            ZFile.bpxwdyn("alloc fi(" + this.ddname + ") da(" + fqdsn + ") reuse shr msg(2)");
            ZUtil.logDiagnostic(5, "ZFile: Allocated " + fqdsn + " to DD:" + this.ddname + " DISP=SHR");
        }
        catch (RcException rce) {
            this.doUnallocShr();
            throw rce;
        }
    }

    private synchronized void doUnallocShr() {
        if (this.ddname != null) {
            try {
                ZFile.bpxwdyn("free fi(" + this.ddname + ") msg(2)");
                ZUtil.logDiagnostic(5, "ZFile: Freed DD:" + this.ddname);
            }
            catch (RcException rce) {
                ZUtil.logDiagnostic(1, "ZFile: Error freeing DD:" + this.ddname + " - " + rce.getMessage());
            }
            finally {
                this.ddname = null;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String[] splitDsnAndMember(String fqdsn) throws ZFileException {
        String[] answer = new String[2];
        int ilp = fqdsn.indexOf(40);
        int irp = fqdsn.indexOf(41);
        if (ilp > 0) {
            if (irp <= ilp + 1 || irp > ilp + 9) throw new ZFileException(fqdsn, Messages.getString("ZFile.InvalidFilename"), 121);
            answer[0] = fqdsn.substring(0, ilp);
            answer[1] = fqdsn.substring(ilp + 1, irp);
            return answer;
        } else {
            answer[0] = fqdsn;
        }
        return answer;
    }

    private void splitExistingPdsAndMember(String fqdsn) throws ZFileException {
        String[] dsnAndMember = ZFile.splitDsnAndMember(fqdsn);
        this.memberName = dsnAndMember[1];
        if (this.memberName != null) {
            char memFirst = this.memberName.charAt(0);
            if (memFirst == '+' || memFirst == '-' || memFirst == '0') {
                this.memberName = null;
                ZUtil.logDiagnostic(3, Messages.getString("ZFile.NotAPDSMember") + fqdsn);
            } else {
                try {
                    DatasetVolumeList dsvl = new DatasetVolumeList();
                    ZFile.locateDSN("//'" + dsnAndMember[0] + "'", dsvl);
                    this.pdsName = dsvl.getReturnedDSN();
                }
                catch (RcException rce) {
                    this.memberName = null;
                    ZUtil.logDiagnostic(3, Messages.getString("ZFile.PDSNotExist") + dsnAndMember[0]);
                }
            }
        }
    }

    private static native boolean basicDDExists(String var0) throws ZFileException;

    private static native void basicBpxwdyn(String var0) throws RcException;

    private static native void fremove(String var0) throws ZFileException;

    private static native void frename(String var0, String var1) throws ZFileException;

    private native void fclose(long var1) throws ZFileException;

    private native void fflush(long var1) throws ZFileException;

    private native byte[] fgetpos(long var1) throws ZFileException;

    private native boolean flocate(long var1, byte[] var3, int var4, int var5, int var6) throws ZFileException;

    private native boolean flocateUnlocked(long var1, byte[] var3, int var4, int var5, int var6) throws ZFileException;

    private native long fopen(String var1, String var2) throws ZFileException;

    private native int fread(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native int freadUnlocked(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native int freadNop(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native void freopen(long var1, String var3) throws ZFileException;

    private native void rewind(long var1) throws ZFileException;

    private native void fseeko(long var1, long var3, int var5) throws ZFileException;

    private native void fsetpos(long var1, byte[] var3) throws ZFileException;

    private native long ftello(long var1) throws ZFileException;

    private native int fupdate(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native void fdelrec(long var1) throws ZFileException;

    private native void fwrite(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native void fwriteNop(long var1, byte[] var3, int var4, int var5) throws ZFileException;

    private native String getActualFilename(long var1) throws ZFileException;

    private native int getBlksize(long var1) throws ZFileException;

    private native long getByteCount(long var1) throws ZFileException;

    private native int getDsorg(long var1) throws ZFileException;

    private native int getLrecl(long var1) throws ZFileException;

    private native int getDevice(long var1) throws ZFileException;

    private native int getOpenMode(long var1) throws ZFileException;

    private native int getModeFlags(long var1) throws ZFileException;

    private native int getRecfm(long var1) throws ZFileException;

    private native long getRecordCount(long var1) throws ZFileException;

    private native int getVsamType(long var1) throws ZFileException;

    private native int getVsamKeyLength(long var1) throws ZFileException;

    private native long getVsamRBA(long var1) throws ZFileException;

    private native long openStderr() throws ZFileException;

    static {
        ZUtil.touch();
        IS_64_BIT = "64".equals(System.getProperty("com.ibm.vm.bitmode"));
        LOCATE_LONG_LEN = IS_64_BIT ? 8 : 4;
    }
}

