/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ZCompressor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZCompressorInputStream
extends FilterInputStream {
    static final int DEFAULT_BUF_SIZE = 8192;
    ZCompressor compressor;
    Buffer cbuf;
    Buffer ebuf;
    boolean readEOF;
    long totalSourceBytes;
    long totalExpandedBytes;
    boolean releaseZCompressorOnClose = false;

    public ZCompressorInputStream(ZCompressor compressor, InputStream in) {
        this(compressor, in, 8192);
    }

    public ZCompressorInputStream(ZCompressor compressor, InputStream in, int buflen) {
        super(in);
        if (compressor == null || in == null) {
            throw new NullPointerException();
        }
        if (buflen <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.compressor = compressor;
        this.cbuf = new Buffer(buflen);
        this.ebuf = new Buffer(buflen);
    }

    public void releaseZCompressorOnClose(boolean value) {
        this.releaseZCompressorOnClose = value;
    }

    public long getTotalSourceBytes() {
        return this.totalSourceBytes;
    }

    public long getTotalExpandedBytes() {
        return this.totalExpandedBytes;
    }

    @Override
    public void close() throws IOException {
        if (this.releaseZCompressorOnClose) {
            this.compressor.release();
        }
        super.close();
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int nRead = this.read(buf);
        if (nRead < 0) {
            return nRead;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] readBuf, int readBufOff, int readBufLen) throws IOException {
        int nRead;
        int readBufRemaining = readBufLen;
        while (readBufRemaining > 0) {
            int nGot = this.ebuf.get(readBuf, readBufOff, readBufRemaining);
            readBufOff += nGot;
            if ((readBufRemaining -= nGot) <= 0 || this.expandMoreData()) continue;
            break;
        }
        if ((nRead = readBufLen - readBufRemaining) == 0 && this.readEOF) {
            nRead = -1;
        } else {
            this.totalExpandedBytes += (long)nRead;
        }
        return nRead;
    }

    private boolean expandMoreData() throws IOException {
        int oldEUsed = this.ebuf.used();
        while (!(this.ebuf.available() <= 0 || this.cbuf.used() <= 1 && this.readEOF)) {
            while (this.cbuf.available() > 1 && !this.readEOF) {
                int cRead = this.cbuf.readMoreFrom(this.in);
                if (cRead < 0) {
                    this.readEOF = true;
                    continue;
                }
                this.totalSourceBytes += (long)cRead;
            }
            if (this.cbuf.used() <= 1) continue;
            this.ebuf.trim();
            ZCompressor.Result rslt = this.compressor.expand(this.ebuf.buf, this.ebuf.end, this.cbuf.buf, this.cbuf.start, this.cbuf.startBitOffset, this.cbuf.used());
            this.ebuf.end += rslt.getTargetBytesUsed();
            this.cbuf.start += rslt.getSourceBytesUsed();
            this.cbuf.startBitOffset = rslt.getExtraCompressedBitsUsed();
            if (this.cbuf.used() <= (this.cbuf.startBitOffset == 0 ? 0 : 1)) continue;
            break;
        }
        return this.ebuf.used() > oldEUsed;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip not supported");
    }

    @Override
    public int available() throws IOException {
        return super.available() + this.ebuf.used();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int limit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    private static class Buffer {
        public byte[] buf;
        public int start;
        public int end;
        public int startBitOffset;

        public Buffer(int length) {
            this.buf = new byte[length];
        }

        public int used() {
            return this.end - this.start;
        }

        public int available() {
            return this.buf.length - this.used();
        }

        public int get(byte[] dest, int destOff, int len) {
            if (len > this.used()) {
                len = this.used();
            }
            if (len > 0) {
                System.arraycopy(this.buf, this.start, dest, destOff, len);
                this.start += len;
            }
            return len;
        }

        public int readMoreFrom(InputStream is) throws IOException {
            this.trim();
            int nRead = 0;
            if (this.end < this.buf.length) {
                nRead = is.read(this.buf, this.end, this.buf.length - this.end);
                if (nRead >= 0) {
                    this.end += nRead;
                } else {
                    return nRead;
                }
            }
            return nRead;
        }

        public void trim() {
            if (this.start > 0) {
                if (this.start < this.end) {
                    System.arraycopy(this.buf, this.start, this.buf, 0, this.end - this.start);
                }
                this.end -= this.start;
                this.start = 0;
            }
        }
    }
}

