/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.ByteUtil;
import com.ibm.jzos.ErrnoException;
import com.ibm.jzos.ExtendedThreadInfo;
import com.ibm.jzos.JvmMonitorDaemonThreadFactory;
import com.ibm.jzos.Messages;
import com.ibm.jzos.Smf121S1GarbageCollector;
import com.ibm.jzos.Smf121S1Header;
import com.ibm.jzos.Smf121S1JavaRuntime;
import com.ibm.jzos.Smf121S1Thread;
import com.ibm.jzos.ZUtil;
import com.ibm.lang.management.GarbageCollectorMXBean;
import com.ibm.lang.management.JvmCpuMonitorInfo;
import com.ibm.lang.management.JvmCpuMonitorMXBean;
import com.ibm.lang.management.MemoryMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

final class Smf121S1Writer
implements Runnable {
    private static final Map<String, String> THREAD_CATEGORY_SHORTENER = Collections.unmodifiableMap(Smf121S1Writer.threadCategoryShortener());
    private RecordConfiguration configuration;

    private static final Map<String, String> threadCategoryShortener() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("System-JVM", "SYS");
        map.put("Application", "APP");
        map.put("Resource-Monitor", "RM");
        map.put("GC", "GC");
        map.put("JIT", "JIT");
        map.put("Other", "OTHER");
        map.put("Application-User1", "APP-U1");
        map.put("Application-User2", "APP-U2");
        map.put("Application-User3", "APP-U3");
        map.put("Application-User4", "APP-U4");
        map.put("Application-User5", "APP-U5");
        return map;
    }

    private static final JvmCpuMonitorMXBean getJvmCpuMonitorMXBean() {
        ObjectName objectName = null;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        JvmCpuMonitorMXBean bean = null;
        try {
            objectName = new ObjectName("com.ibm.lang.management:type=JvmCpuMonitor");
        }
        catch (MalformedObjectNameException e) {
            return bean;
        }
        if (server.isRegistered(objectName)) {
            bean = JMX.newMXBeanProxy(server, objectName, JvmCpuMonitorMXBean.class);
        } else {
            ZUtil.logDiagnostic(5, "JvmCpuMonitorMXBean is not registered");
        }
        return bean;
    }

    private Smf121S1Writer(RecordConfiguration configuration) {
        this.configuration = configuration;
    }

    static final void register(long interval, boolean includeThreadInfo, boolean includeNativeId) {
        RecordConfiguration config = includeThreadInfo && includeNativeId ? RecordConfiguration.THREAD_INFO_WITH_NATIVE_ID : (includeThreadInfo ? RecordConfiguration.THREAD_INFO : RecordConfiguration.SUMMARY_ONLY);
        Smf121S1Writer writer = new Smf121S1Writer(config);
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)writer, "JZOS JVM Shutdown Report"));
        if (interval > 0L) {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new JvmMonitorDaemonThreadFactory());
            scheduledExecutor.scheduleAtFixedRate(writer, 0L, interval, TimeUnit.SECONDS);
        }
    }

    private final byte[] buildSmf121S1Record() {
        int i;
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getPlatformMXBeans(GarbageCollectorMXBean.class);
        int numOfGcSections = garbageCollectors.size();
        ExtendedThreadInfo[] activeThreads = new ExtendedThreadInfo[]{};
        int numOfThreadSections = 0;
        if (this.configuration.containsThreadInfo()) {
            com.ibm.lang.management.ThreadMXBean threadBean = ManagementFactory.getPlatformMXBean(com.ibm.lang.management.ThreadMXBean.class);
            int maxThreadSectionsAllowed = Smf121S1Writer.calculateMaxNumberOfThreadSections(numOfGcSections);
            long[] threadIds = threadBean.getAllThreadIds();
            ThreadInfo[] threads = threadBean.getThreadInfo(threadIds);
            long[] nativeThreadIds = null;
            if (this.configuration.containsNativeThreadId()) {
                nativeThreadIds = threadBean.getNativeThreadIds(threadIds);
            }
            activeThreads = Smf121S1Writer.collectActiveThreads(maxThreadSectionsAllowed, threads, nativeThreadIds);
            numOfThreadSections = activeThreads.length;
        }
        byte[] smfRecord = new byte[Smf121S1Header.length() + Smf121S1JavaRuntime.length() + numOfGcSections * Smf121S1GarbageCollector.length() + numOfThreadSections * Smf121S1Thread.length()];
        Smf121S1Header header = new Smf121S1Header(smfRecord);
        Smf121S1Writer.populateSmfSelfDefiningSection(header, numOfGcSections, numOfThreadSections);
        Smf121S1JavaRuntime jrSection = new Smf121S1JavaRuntime(smfRecord, (int)header.getJavaRuntimeSectionOffset());
        Smf121S1Writer.populateSmfJavaRuntimeSection(jrSection);
        int gcOffset = (int)header.getGcSectionOffset();
        for (i = 0; i < numOfGcSections; ++i) {
            Smf121S1GarbageCollector gcSection = new Smf121S1GarbageCollector(smfRecord, gcOffset);
            Smf121S1Writer.populateSmfGarbageCollectorSection(gcSection, garbageCollectors.get(i));
            gcOffset += Smf121S1GarbageCollector.length();
        }
        int threadOffset = (int)header.getThreadSectionOffset();
        for (i = 0; i < numOfThreadSections; ++i) {
            Smf121S1Thread threadSection = new Smf121S1Thread(smfRecord, threadOffset);
            Smf121S1Writer.populateSmfThreadSection(threadSection, activeThreads[i]);
            threadOffset += Smf121S1Thread.length();
        }
        return smfRecord;
    }

    private static final int calculateMaxNumberOfThreadSections(int numOfGcSections) {
        int maximumSmfRecordLength = 32756;
        int lengthOfGcSections = numOfGcSections * Smf121S1GarbageCollector.length();
        int bytesAvailableToThreadSections = 32756 - Smf121S1Header.length() - Smf121S1JavaRuntime.length() - lengthOfGcSections;
        return bytesAvailableToThreadSections / Smf121S1Thread.length();
    }

    private static final ExtendedThreadInfo[] collectActiveThreads(int maxAllowed, ThreadInfo[] threads, long[] nativeThreadIds) {
        ThreadInfo[] allThreads = threads != null ? threads : new ThreadInfo[]{};
        boolean collectNativeThreadIds = false;
        if (nativeThreadIds != null && nativeThreadIds.length == allThreads.length) {
            collectNativeThreadIds = true;
        }
        ExtendedThreadInfo[] activeThreads = new ExtendedThreadInfo[allThreads.length];
        int activeThreadCount = 0;
        for (int i = 0; i < allThreads.length; ++i) {
            if (allThreads[i] == null) continue;
            activeThreads[activeThreadCount++] = new ExtendedThreadInfo(allThreads[i], collectNativeThreadIds ? nativeThreadIds[i] : -1L);
        }
        if (activeThreadCount > maxAllowed) {
            ZUtil.logDiagnostic(4, String.format("Active threads (%d), maximum allowed (%d)", activeThreadCount, maxAllowed));
            activeThreadCount = maxAllowed;
        }
        if (activeThreadCount == allThreads.length) {
            return activeThreads;
        }
        return Arrays.copyOf(activeThreads, activeThreadCount);
    }

    private static final void populateSmfSelfDefiningSection(Smf121S1Header smfHeader, int numOfGcSections, int numOfThreadSections) {
        smfHeader.setNumberOfTriplets(3);
        ZUtil.logDiagnostic(4, "SMF (121.1) 3 (0x0003) triplets");
        smfHeader.setJavaRuntimeSectionOffset(Smf121S1Header.length());
        ZUtil.logDiagnostic(4, "SMF (121.1) JR section offset: " + Smf121S1Header.length() + Smf121S1Writer.hexDWord(Smf121S1Header.length()));
        smfHeader.setJavaRuntimeSectionLength(Smf121S1JavaRuntime.length());
        ZUtil.logDiagnostic(4, "SMF (121.1) JR section length: " + Smf121S1JavaRuntime.length() + Smf121S1Writer.hexWord(Smf121S1JavaRuntime.length()));
        smfHeader.setNumberOfJavaRuntimeSections(1);
        ZUtil.logDiagnostic(4, "SMF (121.1) 1 (0x0001) JR section");
        long gcSectionOffset = Smf121S1Header.length() + Smf121S1JavaRuntime.length();
        smfHeader.setGcSectionOffset(gcSectionOffset);
        ZUtil.logDiagnostic(4, "SMF (121.1) GC section offset: " + gcSectionOffset + Smf121S1Writer.hexDWord(gcSectionOffset));
        smfHeader.setGcSectionLength(Smf121S1GarbageCollector.length());
        ZUtil.logDiagnostic(4, "SMF (121.1) GC section length: " + Smf121S1GarbageCollector.length() + Smf121S1Writer.hexWord(Smf121S1GarbageCollector.length()));
        smfHeader.setNumberOfGcSections(numOfGcSections);
        ZUtil.logDiagnostic(4, "SMF (121.1) " + numOfGcSections + Smf121S1Writer.hexWord(numOfGcSections) + " GC section(s)");
        long threadSectionOffset = Smf121S1Header.length() + Smf121S1JavaRuntime.length() + numOfGcSections * Smf121S1GarbageCollector.length();
        smfHeader.setThreadSectionOffset(threadSectionOffset);
        ZUtil.logDiagnostic(4, "SMF (121.1) Thread section offset: " + threadSectionOffset + Smf121S1Writer.hexDWord(threadSectionOffset));
        smfHeader.setThreadSectionLength(Smf121S1Thread.length());
        ZUtil.logDiagnostic(4, "SMF (121.1) Thread section length: " + Smf121S1Thread.length() + Smf121S1Writer.hexWord(Smf121S1Thread.length()));
        smfHeader.setNumberOfThreadSections(numOfThreadSections);
        ZUtil.logDiagnostic(4, "SMF (121.1) " + numOfThreadSections + Smf121S1Writer.hexWord(numOfThreadSections) + " Thread section(s)");
    }

    private static final void populateSmfJavaRuntimeSection(Smf121S1JavaRuntime smfJrSection) {
        smfJrSection.setFieldFlag1(128);
        ZUtil.logDiagnostic(4, "JVM field flags: " + String.format("0x%08x", smfJrSection.getFieldFlags() & 0xFFFFFFFFL));
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String name = runtimeBean.getName();
        long startTime = runtimeBean.getStartTime();
        long uptime = runtimeBean.getUptime();
        smfJrSection.setJvmName(name);
        ZUtil.logDiagnostic(4, "JVM name: " + name);
        smfJrSection.setStartTime(startTime);
        ZUtil.logDiagnostic(4, "JVM start time: " + new Date(startTime).toString() + Smf121S1Writer.hexQWord(startTime));
        smfJrSection.setUptime(uptime);
        ZUtil.logDiagnostic(4, "JVM uptime: " + uptime + Smf121S1Writer.hexQWord(uptime));
        MemoryMXBean memoryBean = ManagementFactory.getPlatformMXBean(MemoryMXBean.class);
        String gcMode = memoryBean.getGCMode();
        smfJrSection.setGCMode(gcMode);
        ZUtil.logDiagnostic(4, "GC mode: " + gcMode);
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        int peakThreadCount = threadBean.getPeakThreadCount();
        int threadCount = threadBean.getThreadCount();
        smfJrSection.setPeakThreadCount(peakThreadCount);
        ZUtil.logDiagnostic(4, "Peak thread count: " + peakThreadCount + Smf121S1Writer.hexDWord(peakThreadCount));
        smfJrSection.setThreadCount(threadCount);
        ZUtil.logDiagnostic(4, "Thread count: " + threadCount + Smf121S1Writer.hexDWord(threadCount));
        JvmCpuMonitorMXBean cpuMonitorBean = Smf121S1Writer.getJvmCpuMonitorMXBean();
        JvmCpuMonitorInfo cpuMonitorInfo = null;
        long applicationCpuTime = -1L;
        long systemJvmCpuTime = -1L;
        long gcCpuTime = -1L;
        long jitCpuTime = -1L;
        if (cpuMonitorBean != null) {
            try {
                cpuMonitorInfo = cpuMonitorBean.getThreadsCpuUsage();
                applicationCpuTime = cpuMonitorInfo.getApplicationCpuTime();
                systemJvmCpuTime = cpuMonitorInfo.getSystemJvmCpuTime();
                gcCpuTime = cpuMonitorInfo.getGcCpuTime();
                jitCpuTime = cpuMonitorInfo.getJitCpuTime();
            }
            catch (UnsupportedOperationException uoe) {
                ZUtil.logDiagnostic(5, "CPU monitoring is disabled");
            }
        }
        smfJrSection.setApplicationCpuTime(applicationCpuTime);
        ZUtil.logDiagnostic(4, "Application CPU time: " + applicationCpuTime + Smf121S1Writer.hexQWord(applicationCpuTime));
        smfJrSection.setSystemJvmCpuTime(systemJvmCpuTime);
        ZUtil.logDiagnostic(4, "System-JVM CPU time: " + systemJvmCpuTime + Smf121S1Writer.hexQWord(systemJvmCpuTime));
        smfJrSection.setGcCpuTime(gcCpuTime);
        ZUtil.logDiagnostic(4, "GC CPU time: " + gcCpuTime + Smf121S1Writer.hexQWord(gcCpuTime));
        smfJrSection.setJitCpuTime(jitCpuTime);
        ZUtil.logDiagnostic(4, "JIT CPU time: " + jitCpuTime + Smf121S1Writer.hexQWord(jitCpuTime));
    }

    private static final void populateSmfGarbageCollectorSection(Smf121S1GarbageCollector smfGcSection, GarbageCollectorMXBean gcBean) {
        String name = gcBean.getName();
        long collectionCount = gcBean.getCollectionCount();
        long collectionTime = gcBean.getCollectionTime();
        long totalMemoryFreed = gcBean.getTotalMemoryFreed();
        long totalCompacts = gcBean.getTotalCompacts();
        long memoryUsed = gcBean.getMemoryUsed();
        smfGcSection.setGcName(name);
        String prefix = String.format("GC (%s)", name);
        smfGcSection.setCollectionCount(collectionCount);
        ZUtil.logDiagnostic(4, prefix + " collection count: " + collectionCount + Smf121S1Writer.hexQWord(collectionCount));
        smfGcSection.setCollectionTime(collectionTime);
        ZUtil.logDiagnostic(4, prefix + " collection time: " + collectionTime + Smf121S1Writer.hexQWord(collectionTime));
        smfGcSection.setTotalMemoryFreed(totalMemoryFreed);
        ZUtil.logDiagnostic(4, prefix + " total memory freed: " + totalMemoryFreed + Smf121S1Writer.hexQWord(totalMemoryFreed));
        smfGcSection.setTotalCompacts(totalCompacts);
        ZUtil.logDiagnostic(4, prefix + " total compacts: " + totalCompacts + Smf121S1Writer.hexQWord(totalCompacts));
        smfGcSection.setMemoryUsed(memoryUsed);
        ZUtil.logDiagnostic(4, prefix + " memory used: " + memoryUsed + Smf121S1Writer.hexQWord(memoryUsed));
    }

    private static final void populateSmfThreadSection(Smf121S1Thread smfThreadSection, ExtendedThreadInfo threadInfo) {
        long id = threadInfo.getThreadInfo().getThreadId();
        String name = threadInfo.getThreadInfo().getThreadName();
        long nativeId = threadInfo.getNativeThreadId();
        JvmCpuMonitorMXBean cpuMonitorBean = Smf121S1Writer.getJvmCpuMonitorMXBean();
        String category = "";
        if (cpuMonitorBean != null) {
            try {
                category = cpuMonitorBean.getThreadCategory(id);
                category = THREAD_CATEGORY_SHORTENER.containsKey(category) ? THREAD_CATEGORY_SHORTENER.get(category) : "";
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long cpuTime = -1L;
        try {
            cpuTime = threadBean.getThreadCpuTime(id);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        smfThreadSection.setThreadId(id);
        String prefix = String.format("Thread (%d)", id);
        ZUtil.logDiagnostic(4, "Thread ID: " + id + Smf121S1Writer.hexQWord(id));
        smfThreadSection.setThreadName(name);
        ZUtil.logDiagnostic(4, prefix + " name: " + name);
        smfThreadSection.setThreadCategory(category);
        ZUtil.logDiagnostic(4, prefix + " category: " + category);
        smfThreadSection.setThreadCpuTime(cpuTime);
        ZUtil.logDiagnostic(4, prefix + " total CPU time: " + cpuTime + Smf121S1Writer.hexQWord(cpuTime));
        smfThreadSection.setNativeThreadId(nativeId);
        ZUtil.logDiagnostic(4, prefix + " native thread ID: " + nativeId + Smf121S1Writer.hexQWord(nativeId));
    }

    private static final void writeSmf121S1Record(byte[] smfRecordBytes) {
        try {
            ZUtil.smfRecord(121, 1, smfRecordBytes);
            ZUtil.logDiagnostic(4, Messages.getString("Smf121S1Writer.SmfLogged"));
        }
        catch (ErrnoException e) {
            ZUtil.logDiagnostic(3, Messages.getString("Smf121S1Writer.SmfNotLogged"));
            if (e.getErrno() == 139) {
                ZUtil.logDiagnostic(3, Messages.getString("Smf121S1Writer.NoAccessRACF"));
            } else if (e.getErrno() == 157 && e.getReasonCode() == 1030) {
                ZUtil.logDiagnostic(3, Messages.getString("Smf121S1Writer.NotAccepting"));
            } else if (e.getErrno() == 157 && e.getReasonCode() == 1031) {
                ZUtil.logDiagnostic(3, Messages.getString("Smf121S1Writer.NotActive"));
            } else {
                ZUtil.logDiagnostic(3, "SMF ERRNO=" + e.getErrno() + " RC=" + e.getReasonCode());
            }
        }
        finally {
            String smfHex = ByteUtil.toHexString(smfRecordBytes);
            ZUtil.logDiagnostic(5, "SMF 121.1: " + smfHex);
        }
    }

    @Override
    public synchronized void run() {
        long threadId = Thread.currentThread().getId();
        JvmCpuMonitorMXBean cpuMonitorBean = Smf121S1Writer.getJvmCpuMonitorMXBean();
        if (cpuMonitorBean != null) {
            try {
                String category = cpuMonitorBean.getThreadCategory(threadId);
                if (!"Resource-Monitor".equalsIgnoreCase(category)) {
                    cpuMonitorBean.setThreadCategory(threadId, "Resource-Monitor");
                }
            }
            catch (IllegalArgumentException iae) {
                ZUtil.logDiagnostic(4, "Unable to set JZOS JVM monitor and report thread (" + threadId + ") category to Resource-Monitor");
            }
        }
        Smf121S1Writer.writeSmf121S1Record(this.buildSmf121S1Record());
    }

    private static final String hexWord(int decimal) {
        return String.format(" (0x%04x)", decimal & 0xFFFF);
    }

    private static final String hexDWord(int decimal) {
        return String.format(" (0x%08x)", decimal & 0xFFFFFFFF);
    }

    private static final String hexDWord(long decimal) {
        return String.format(" (0x%08x)", decimal & 0xFFFFFFFFL);
    }

    private static final String hexQWord(long decimal) {
        return String.format(" (0x%016x)", decimal & 0xFFFFFFFFFFFFFFFFL);
    }

    private static enum RecordConfiguration {
        SUMMARY_ONLY,
        THREAD_INFO,
        THREAD_INFO_WITH_NATIVE_ID;


        boolean containsThreadInfo() {
            return this == THREAD_INFO || this == THREAD_INFO_WITH_NATIVE_ID;
        }

        boolean containsNativeThreadId() {
            return this == THREAD_INFO_WITH_NATIVE_ID;
        }
    }
}

