/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.JesSymbols;
import com.ibm.jzos.JesVsam;
import com.ibm.jzos.JesVsamException;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MvsJobSubmitter {
    public static final int DEFAULT_RDR_LRECL = 80;
    public static final boolean DEFAULT_RDR_FIXED_RECFM = true;
    public static final char DEFAULT_RDR_CLASS = '*';
    public static final int MAX_JCL_SYMBOL_NAME_LEN = 8;
    private int rdrLrecl = 80;
    private boolean rdrFixedRecfm = true;
    private char rdrClass = (char)42;
    private String internalReaderDD = null;
    private JesVsam internalReader = null;
    private byte[] rbar = null;
    private List<String> symbolNames = null;
    private boolean JesSymbolService = false;
    private String sysCorrLastJob = null;
    private String subsystem = null;
    private static final String PRIMARY_SUBSYS = JesSymbols.PRIMARY_SUBSYS;

    public MvsJobSubmitter() throws IOException {
        this.openInternalReader();
    }

    public MvsJobSubmitter(int rdrLrecl, boolean rdrIsFixedRecfm, char rdrClass) throws IOException {
        this.rdrFixedRecfm = rdrIsFixedRecfm;
        this.rdrLrecl = rdrLrecl;
        this.rdrClass = rdrClass;
        this.openInternalReader();
    }

    public MvsJobSubmitter(int rdrLrecl, boolean rdrIsFixedRecfm, char rdrClass, String subsystem, List<String> symbolNames) throws IOException {
        if (symbolNames == null) {
            throw new NullPointerException("symbolNames is null");
        }
        for (String name : symbolNames) {
            if (name == null) {
                throw new NullPointerException("a symbol name is null");
            }
            if (name.length() >= 1 && name.length() <= 8) continue;
            throw new IllegalArgumentException("Invalid symbol name '" + name + "'. Length of symbols submitted to a job must be between 1 and " + 8);
        }
        this.subsystem = subsystem == null || subsystem.equals("") ? PRIMARY_SUBSYS : subsystem.trim();
        this.rdrFixedRecfm = rdrIsFixedRecfm;
        this.rdrLrecl = rdrLrecl;
        this.rdrClass = rdrClass;
        this.symbolNames = new ArrayList<String>(symbolNames);
        this.JesSymbolService = true;
        this.openInternalReader();
    }

    public char getRdrClass() {
        return this.rdrClass;
    }

    public int getRdrLrecl() {
        return this.rdrLrecl;
    }

    public boolean isRdrFixedRecfm() {
        return this.rdrFixedRecfm;
    }

    public void write(String line) throws IOException {
        this.write(line.getBytes(ZUtil.getDefaultPlatformEncoding()));
    }

    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.internalReader == null) {
            throw new IllegalStateException("Internal reader is not open");
        }
        this.internalReader.write(bytes, offset, length);
    }

    public void close() throws IOException {
        if (this.internalReader == null) {
            throw new IllegalStateException("Internal reader is not open");
        }
        try {
            this.rbar = this.internalReader.close();
        }
        finally {
            this.internalReader = null;
        }
        if (this.JesSymbolService) {
            Map<String, String> symbols = JesSymbols.extract("SYS_CORR_LASTJOB");
            this.sysCorrLastJob = symbols.get("SYS_CORR_LASTJOB");
        }
        try {
            ZFile.bpxwdyn("free fi(" + this.internalReaderDD + ") msg(2)");
        }
        catch (RcException rce) {
            throw new JesVsamException(1, rce.getRc(), 0, "Error freeing internal reader, BPXWDYN rc=" + rce.getRc());
        }
        finally {
            this.internalReaderDD = null;
        }
    }

    public String getJobid() throws IOException {
        String jobid;
        if (this.internalReader != null) {
            this.close();
        }
        if ((jobid = new String(this.rbar, ZUtil.getDefaultPlatformEncoding()).trim()).length() == 0) {
            throw new IOException("No job was created; jobid was not found");
        }
        return jobid;
    }

    public String getJobCorrelator() throws IOException {
        if (this.internalReader != null) {
            this.close();
        }
        return this.sysCorrLastJob;
    }

    private void openInternalReader() throws IOException {
        this.allocInternalReader();
        this.internalReader = new JesVsam(this.internalReaderDD, true);
        this.internalReader.setLrecl(this.rdrLrecl);
    }

    private void allocInternalReader() throws IOException {
        if (this.JesSymbolService) {
            this.internalReaderDD = JesSymbols.allocReader(this.subsystem, "" + this.rdrClass, this.rdrLrecl, !this.rdrFixedRecfm, this.symbolNames);
        }
        try {
            this.internalReaderDD = ZFile.allocDummyDDName();
            String sysoutArg = this.rdrClass == '*' ? "" : "(" + this.rdrClass + ")";
            String cmd = "alloc fi(" + this.internalReaderDD + ") sysout" + sysoutArg + " writer(intrdr) recfm(" + (this.rdrFixedRecfm ? "F" : "V") + ")  lrecl(" + this.rdrLrecl + ")  reuse msg(2)";
            ZFile.bpxwdyn(cmd);
        }
        catch (RcException rce) {
            throw new JesVsamException(1, rce.getRc(), 0, "Error allocating internal reader rc=" + rce.getRc());
        }
    }

    static {
        ZUtil.touch();
    }
}

