/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.fields.AssemblerDatatypeFactory;
import com.ibm.jzos.fields.BinaryAsIntField;
import com.ibm.jzos.fields.StringField;

class JesSymbolTableEntry {
    protected static AssemblerDatatypeFactory factory = new AssemblerDatatypeFactory();
    public static final int JSYENTRY;
    protected static final StringField JSYENAME;
    protected static final BinaryAsIntField JSYEVALO;
    protected static final BinaryAsIntField JSYEVALS;
    public static final int JSYESIZ1 = 24;
    public static final int JSYESIZE = 24;
    public static final int _DEFAULT_LEN;
    protected byte[] _byteBuffer;
    protected int _byteBufferOffset;
    private String jsyename;
    private Integer jsyevalo;
    private Integer jsyevals;

    public JesSymbolTableEntry() {
        this._byteBuffer = new byte[_DEFAULT_LEN];
    }

    public JesSymbolTableEntry(byte[] buffer, int bufOffset) {
        this._byteBuffer = buffer;
        this._byteBufferOffset = bufOffset;
    }

    public byte[] getByteBuffer() {
        return this._byteBuffer;
    }

    public int getByteBufferOffset() {
        return this._byteBufferOffset;
    }

    public String getJsyename() {
        if (this.jsyename == null) {
            this.jsyename = JSYENAME.getString(this._byteBuffer, this._byteBufferOffset);
        }
        return this.jsyename;
    }

    public void setJsyename(String jsyename) {
        if (JSYENAME.equals(this.jsyename, jsyename)) {
            return;
        }
        JSYENAME.putString(jsyename, this._byteBuffer, this._byteBufferOffset);
        this.jsyename = jsyename;
    }

    public int getJsyevalo() {
        if (this.jsyevalo == null) {
            this.jsyevalo = new Integer(JSYEVALO.getInt(this._byteBuffer, this._byteBufferOffset));
        }
        return this.jsyevalo;
    }

    public void setJsyevalo(int jsyevalo) {
        if (JSYEVALO.equals(this.jsyevalo, jsyevalo)) {
            return;
        }
        JSYEVALO.putInt(jsyevalo, this._byteBuffer, this._byteBufferOffset);
        this.jsyevalo = new Integer(jsyevalo);
    }

    public int getJsyevals() {
        if (this.jsyevals == null) {
            this.jsyevals = new Integer(JSYEVALS.getInt(this._byteBuffer, this._byteBufferOffset));
        }
        return this.jsyevals;
    }

    public void setJsyevals(int jsyevals) {
        if (JSYEVALS.equals(this.jsyevals, jsyevals)) {
            return;
        }
        JSYEVALS.putInt(jsyevals, this._byteBuffer, this._byteBufferOffset);
        this.jsyevals = new Integer(jsyevals);
    }

    static {
        factory.setStringTrimDefault(false);
        JSYENTRY = factory.getOffset();
        JSYENAME = factory.getStringField(16);
        JSYEVALO = factory.getBinaryAsIntField(4, true);
        JSYEVALS = factory.getBinaryAsIntField(2, true);
        factory.getBinaryAsIntField(2, false);
        _DEFAULT_LEN = factory.getMaximumOffset();
    }
}

