/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ByteUtil {
    public static byte[] intAsBytes(int i) {
        byte[] bytes = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return bytes;
    }

    public static byte[] longAsBytes(long l) {
        byte[] bytes = new byte[8];
        ByteUtil.putLong(l, bytes, 0);
        return bytes;
    }

    public static void putInt(int i, byte[] bytes, int offset) {
        bytes[offset] = (byte)(i >>> 24 & 0xFF);
        bytes[offset + 1] = (byte)(i >>> 16 & 0xFF);
        bytes[offset + 2] = (byte)(i >>> 8 & 0xFF);
        bytes[offset + 3] = (byte)(i & 0xFF);
    }

    public static void putLong(long l, byte[] bytes, int offset, int len) {
        int limit;
        if (len < 1) {
            throw new IllegalArgumentException("Invalid length");
        }
        for (int n = limit = offset + len - 1; n >= offset; --n) {
            bytes[n] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
    }

    public static void putLong(long l, byte[] bytes, int offset) {
        ByteUtil.putLong(l, bytes, offset, 8);
    }

    public static int putString(String str, byte[] bytes, int offset, int length, String encoding) {
        if (str.length() > length) {
            throw new IllegalArgumentException("String '" + str + "' longer than " + length + " bytes");
        }
        StringBuffer sb = new StringBuffer(str);
        int pad = length - str.length();
        for (int i = 0; i < pad; ++i) {
            sb.append(' ');
        }
        byte[] ba = null;
        try {
            ba = sb.toString().getBytes(encoding);
        }
        catch (UnsupportedEncodingException ee) {
            throw new RuntimeException(ee);
        }
        System.arraycopy(ba, 0, bytes, offset, ba.length);
        return length;
    }

    public static int bytesAsInt(byte[] bytes) {
        return ByteUtil.bytesAsInt(bytes, 0, bytes.length);
    }

    public static int bytesAsInt(byte[] bytes, int offset, int length) {
        if (length > 4) {
            throw new IllegalArgumentException("Only 4 or fewer bytes can fit into an int");
        }
        int val = 0;
        int last = offset + length;
        for (int i = offset; i < last; ++i) {
            val <<= 8;
            val |= bytes[i] & 0xFF;
        }
        return val;
    }

    public static long bytesAsLong(byte[] bytes) {
        return ByteUtil.bytesAsLong(bytes, 0, bytes.length);
    }

    public static long bytesAsLong(byte[] bytes, int offset, int length) {
        if (length > 8) {
            throw new IllegalArgumentException("Only 8 or fewer bytes can fit into a long");
        }
        long val = 0L;
        int last = offset + length;
        for (int i = offset; i < last; ++i) {
            val <<= 8;
            val |= (long)(bytes[i] & 0xFF);
        }
        return val;
    }

    public static String bytesAsString(byte[] bytes, int offset, int length, String encoding) {
        String str;
        try {
            str = new String(bytes, offset, length, encoding);
            str = str.trim();
        }
        catch (UnsupportedEncodingException ee) {
            throw new RuntimeException(ee);
        }
        return str;
    }

    public static long unpackLong(byte[] bytes, int offset, int length, boolean isSigned) {
        long val = 0L;
        for (int i = 0; i < length; ++i) {
            int high_digit = bytes[offset + i] >>> 4 & 0xF;
            int low_digit = bytes[offset + i] & 0xF;
            if (i == length - 1 && isSigned) {
                val = val * 10L + (long)high_digit;
                if (low_digit != 13 && low_digit != 11) continue;
                val = -val;
                continue;
            }
            val = val * 100L + (long)(high_digit * 10) + (long)low_digit;
        }
        return val;
    }

    public static void dumpHex(String label, byte[] bytes, OutputStream ostream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(ostream));
        ByteUtil.dumpHex(label, bytes, 0, bytes.length, 32, writer);
        ((Writer)writer).flush();
    }

    public static void dumpHex(String label, byte[] bytes, OutputStream ostream, String encoding) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(ostream, encoding));
        ByteUtil.dumpHex(label, bytes, 0, bytes.length, 32, writer);
        ((Writer)writer).flush();
    }

    public static void dumpHex(String label, byte[] bytes, Writer writer) throws IOException {
        ByteUtil.dumpHex(label, bytes, 0, bytes.length, 32, writer);
    }

    public static void dumpHex(String label, byte[] bytes, int offset, int len, int bytesPerLine, Writer writer) throws IOException {
        if (label != null) {
            writer.write(label);
            writer.write("\n");
        }
        int limit = offset + len;
        int labelDigits = 4;
        if (limit >= 65536) {
            labelDigits = 8;
        }
        boolean firstLine = true;
        for (int i = 0; i < len; ++i) {
            if (i % bytesPerLine == 0) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    writer.write("\n");
                }
                writer.write("0x");
                writer.write(ByteUtil.toHexString(offset + i, labelDigits));
                writer.write(": ");
            } else if (i % 4 == 0) {
                writer.write(" ");
            }
            writer.write(ByteUtil.toHexString(bytes[offset + i], 2));
        }
        writer.write("\n");
    }

    public static String toHexString(int i, int numDigits) {
        String answer = Integer.toHexString(i);
        int len = answer.length();
        if (len < numDigits) {
            return "000000000000000000000000000000000000".substring(0, numDigits - len) + answer;
        }
        if (len > numDigits) {
            return answer.substring(len - numDigits);
        }
        return answer;
    }

    public static String toHexString(byte[] bytes) {
        return ByteUtil.toHexString(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int offset, int len) {
        StringBuffer sb = new StringBuffer(len * 2);
        int limit = offset + len;
        for (int i = offset; i < limit; ++i) {
            sb.append(ByteUtil.toHexString(bytes[i], 2));
        }
        return sb.toString();
    }
}

