/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos;

import com.ibm.jzos.Bsam;
import com.ibm.jzos.BsamFbRecordReader;
import com.ibm.jzos.BsamVRecordReader;
import com.ibm.jzos.BsamVbsRecordReader;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.ZFileException;
import java.util.regex.Pattern;

class BsamRecordReader
extends RecordReader {
    protected Bsam bsam;

    protected BsamRecordReader(Bsam bsam) {
        this.bsam = bsam;
    }

    public static RecordReader newReaderForDD(String ddname) throws ZFileException {
        if (ddname == null) {
            throw new NullPointerException("The ddname is null");
        }
        if (!Pattern.matches("^[a-zA-Z$#@][0-9a-zA-Z$#@]{0,7}$", ddname)) {
            throw new UnsupportedOperationException("The specified ddname (" + ddname + ") is not supported");
        }
        Bsam bsam = new Bsam(ddname, 128);
        BsamRecordReader reader = null;
        if ((bsam.getRecfmBits() & 4) == 4) {
            reader = new BsamRecordReader(bsam);
        } else if ((bsam.getRecfmBits() & 1) == 1) {
            reader = (bsam.getRecfmBits() & 8) == 0 ? new BsamRecordReader(bsam) : new BsamFbRecordReader(bsam);
        } else if ((bsam.getRecfmBits() & 2) == 2) {
            reader = (bsam.getRecfmBits() & 0x10) == 16 ? new BsamVbsRecordReader(bsam) : new BsamVRecordReader(bsam);
        } else {
            throw new IllegalArgumentException("Record format is not supported");
        }
        return reader;
    }

    @Override
    public synchronized int read(byte[] buf) throws ZFileException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public synchronized int read(byte[] buf, int offset, int len) throws ZFileException {
        int nRead = this.bsam.readBlock(buf, offset, len);
        if (nRead != -1 && (this.bsam.getRecfmBits() & 1) == 1 && nRead != this.getBlksize()) {
            throw this.bsam.newZFileException(" with fixed blksize=" + this.getBlksize() + " contains invalid record/block with length= " + nRead, 121);
        }
        return nRead;
    }

    @Override
    public synchronized void close() throws ZFileException {
        this.bsam.close();
        this.doAutoFree();
    }

    @Override
    public synchronized int getLrecl() {
        return this.bsam.getLrecl();
    }

    @Override
    public synchronized int getBlksize() {
        return this.bsam.getBlksize();
    }

    @Override
    public synchronized int getRecfmBits() {
        return this.bsam.getRecfmBits();
    }

    @Override
    public synchronized String getRecfm() {
        return this.bsam.getRecfm();
    }

    @Override
    public synchronized String getDDName() {
        return this.bsam.getDDName();
    }

    @Override
    public synchronized String getDsn() {
        return this.bsam.getDsn();
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("(");
        if (this.bsam != null) {
            sb.append("ddname=" + this.getDDName());
            sb.append(",dsn=" + this.getDsn());
        }
        sb.append(")");
        return sb.toString();
    }
}

